/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.geoloc;

import java.util.EventObject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.extensions.geoloc.GeoLocationEvent;
import rocks.xmpp.extensions.geoloc.model.GeoLocation;
import rocks.xmpp.extensions.pubsub.PubSubManager;
import rocks.xmpp.extensions.pubsub.PubSubService;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.event.Event;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class GeoLocationManager
extends Manager {
    private final Set<Consumer<GeoLocationEvent>> geoLocationListeners = new CopyOnWriteArraySet<Consumer<GeoLocationEvent>>();
    private final Consumer<MessageEvent> messageListener = e -> {
        Message message = e.getMessage();
        Event event = (Event)message.getExtension(Event.class);
        if (event != null) {
            for (Item item : event.getItems()) {
                Object payload = item.getPayload();
                if (!(payload instanceof GeoLocation)) continue;
                XmppUtils.notifyEventListeners(this.geoLocationListeners, (EventObject)new GeoLocationEvent((Object)this, (GeoLocation)payload, message.getFrom()));
            }
        }
    };

    private GeoLocationManager(XmppSession xmppSession) {
        super(xmppSession, true);
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addInboundMessageListener(this.messageListener);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeInboundMessageListener(this.messageListener);
    }

    public AsyncResult<String> publish(GeoLocation geoLocation) {
        PubSubService pepService = ((PubSubManager)((Object)this.xmppSession.getManager(PubSubManager.class))).createPersonalEventingService();
        return pepService.node("http://jabber.org/protocol/geoloc").publish(geoLocation);
    }

    public void addGeoLocationListener(Consumer<GeoLocationEvent> geoLocationListener) {
        this.geoLocationListeners.add(geoLocationListener);
    }

    public void removeGeoLocationListener(Consumer<GeoLocationEvent> geoLocationListener) {
        this.geoLocationListeners.remove(geoLocationListener);
    }

    protected void dispose() {
        this.geoLocationListeners.clear();
    }
}

