/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.last;

import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.idle.model.Idle;
import rocks.xmpp.extensions.last.model.LastActivity;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class LastActivityManager
extends Manager
implements ExtensionProtocol,
DiscoverableInfo {
    private static final Set<String> FEATURES = Collections.singleton("jabber:iq:last");
    private final Consumer<PresenceEvent> outboundPresenceListener;
    private final IQHandler iqHandler;
    private Supplier<Instant> idleStrategy;
    private Instant lastSentStanza = Instant.now();
    private final Consumer<MessageEvent> outboundMessageListener;

    private LastActivityManager(XmppSession xmppSession) {
        super(xmppSession);
        this.idleStrategy = this::getLastSentStanzaTime;
        this.outboundPresenceListener = e -> {
            Presence presence = e.getPresence();
            if (presence.getTo() == null) {
                LastActivityManager lastActivityManager = this;
                synchronized (lastActivityManager) {
                    if (this.idleStrategy != null && presence.isAvailable() && EnumSet.of(Presence.Show.AWAY, Presence.Show.XA).contains(presence.getShow())) {
                        Instant idleSince = this.idleStrategy.get();
                        if (idleSince != null) {
                            if (!presence.hasExtension(Idle.class)) {
                                presence.addExtension((Object)Idle.since((OffsetDateTime)OffsetDateTime.ofInstant(idleSince, ZoneOffset.UTC)));
                            }
                            if (!presence.hasExtension(LastActivity.class)) {
                                presence.addExtension((Object)new LastActivity(LastActivityManager.getSecondsSince(idleSince), presence.getStatus()));
                            }
                        }
                    } else {
                        this.lastSentStanza = Instant.now();
                    }
                }
            }
        };
        this.iqHandler = new AbstractIQHandler(LastActivity.class, new IQ.Type[]{IQ.Type.GET}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IQ processRequest(IQ iq) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    Instant idleSince;
                    Instant instant = idleSince = LastActivityManager.this.idleStrategy != null ? LastActivityManager.this.idleStrategy.get() : null;
                    if (idleSince != null) {
                        return iq.createResult((Object)new LastActivity(LastActivityManager.getSecondsSince(idleSince), null));
                    }
                    return iq.createError(Condition.SERVICE_UNAVAILABLE);
                }
            }
        };
        this.outboundMessageListener = e -> {
            LastActivityManager lastActivityManager = this;
            synchronized (lastActivityManager) {
                this.lastSentStanza = Instant.now();
            }
        };
    }

    static long getSecondsSince(Instant date) {
        return Math.max(0L, Duration.between(date, Instant.now()).getSeconds());
    }

    public synchronized Instant getLastSentStanzaTime() {
        return this.lastSentStanza;
    }

    public synchronized void setIdleStrategy(Supplier<Instant> idleStrategy) {
        this.idleStrategy = idleStrategy;
    }

    public synchronized Supplier<Instant> getIdleStrategy() {
        return this.idleStrategy;
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addOutboundPresenceListener(this.outboundPresenceListener);
        this.xmppSession.addOutboundMessageListener(this.outboundMessageListener);
        this.xmppSession.addIQHandler(this.iqHandler);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeOutboundPresenceListener(this.outboundPresenceListener);
        this.xmppSession.removeOutboundMessageListener(this.outboundMessageListener);
        this.xmppSession.removeIQHandler(this.iqHandler);
    }

    public AsyncResult<LastActivity> getLastActivity(Jid jid) {
        return this.xmppSession.query(IQ.get((Jid)jid, (Object)new LastActivity()), LastActivity.class);
    }

    public final String getNamespace() {
        return "jabber:iq:last";
    }

    public final Set<String> getFeatures() {
        return FEATURES;
    }
}

