/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.InboundMessageHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.items.DiscoverableItem;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.disco.model.items.ItemProvider;
import rocks.xmpp.extensions.muc.ChatRoom;
import rocks.xmpp.extensions.muc.ChatService;
import rocks.xmpp.extensions.muc.InvitationEvent;
import rocks.xmpp.extensions.muc.conference.model.DirectInvitation;
import rocks.xmpp.extensions.muc.model.user.Invite;
import rocks.xmpp.extensions.muc.model.user.MucUser;
import rocks.xmpp.extensions.rsm.ResultSetProvider;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class MultiUserChatManager
implements InboundMessageHandler,
ItemProvider,
ExtensionProtocol,
DiscoverableInfo {
    private static final Set<String> FEATURES = Collections.singleton("http://jabber.org/protocol/muc");
    private static final String ROOMS_NODE = "http://jabber.org/protocol/muc#rooms";
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final Set<Consumer<InvitationEvent>> invitationListeners = new CopyOnWriteArraySet<Consumer<InvitationEvent>>();
    private final Map<Jid, DiscoverableItem> enteredRoomsMap = new ConcurrentSkipListMap<Jid, DiscoverableItem>();
    private final XmppSession xmppSession;

    private MultiUserChatManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
    }

    public void addInvitationListener(Consumer<InvitationEvent> invitationListener) {
        this.invitationListeners.add(invitationListener);
    }

    public void removeInvitationListener(Consumer<InvitationEvent> invitationListener) {
        this.invitationListeners.remove(invitationListener);
    }

    public AsyncResult<List<ChatService>> discoverChatServices() {
        return this.serviceDiscoveryManager.discoverServices(this.xmppSession.getRemoteXmppAddress(), Identity.conferenceText()).thenApply(services -> services.stream().map(service -> new ChatService(service.getJid(), service.getName(), this.xmppSession, this.serviceDiscoveryManager, this)).collect(Collectors.toList()));
    }

    public AsyncResult<List<Item>> discoverEnteredRooms(Jid contact) {
        return this.serviceDiscoveryManager.discoverItems(contact, ROOMS_NODE).thenApply(ItemNode::getItems);
    }

    public ChatService createChatService(Jid chatService) {
        return new ChatService(chatService, null, this.xmppSession, this.serviceDiscoveryManager, this);
    }

    public ChatRoom createChatRoom(Jid roomAddress) {
        return new ChatRoom(roomAddress, null, this.xmppSession, this.serviceDiscoveryManager, this);
    }

    void roomEntered(final ChatRoom chatRoom, final String nick) {
        this.enteredRoomsMap.put(chatRoom.getAddress(), new DiscoverableItem(){

            public String getName() {
                return nick;
            }

            public Jid getJid() {
                return chatRoom.getAddress();
            }

            public String getNode() {
                return null;
            }

            public String getId() {
                return nick;
            }
        });
    }

    void roomExited(ChatRoom chatRoom) {
        this.enteredRoomsMap.remove(chatRoom.getAddress());
    }

    public ResultSetProvider<DiscoverableItem> getItems(Jid to, Jid from, String node, Locale locale) {
        if (this.isEnabled() && ROOMS_NODE.equals(node)) {
            return ResultSetProvider.forItems(this.enteredRoomsMap.values());
        }
        return null;
    }

    public final String getNamespace() {
        return "http://jabber.org/protocol/muc";
    }

    public final boolean isEnabled() {
        return !this.invitationListeners.isEmpty();
    }

    public final Set<String> getFeatures() {
        return FEATURES;
    }

    public final void handleInboundMessage(MessageEvent e) {
        Message message = e.getMessage();
        MucUser mucUser = (MucUser)message.getExtension(MucUser.class);
        if (mucUser != null) {
            for (Invite invite : mucUser.getInvites()) {
                XmppUtils.notifyEventListeners(this.invitationListeners, (EventObject)new InvitationEvent(this, this.xmppSession, invite.getFrom(), message.getFrom(), invite.getReason(), mucUser.getPassword(), invite.isContinue(), invite.getThread(), true));
            }
        } else {
            DirectInvitation directInvitation = (DirectInvitation)message.getExtension(DirectInvitation.class);
            if (directInvitation != null) {
                XmppUtils.notifyEventListeners(this.invitationListeners, (EventObject)new InvitationEvent(this, this.xmppSession, message.getFrom(), directInvitation.getRoomAddress(), directInvitation.getReason(), directInvitation.getPassword(), directInvitation.isContinue(), directInvitation.getThread(), false));
            }
        }
    }
}

