/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.reach;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.InboundMessageHandler;
import rocks.xmpp.core.stanza.InboundPresenceHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.OutboundPresenceHandler;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.event.Event;
import rocks.xmpp.extensions.reach.ReachabilityEvent;
import rocks.xmpp.extensions.reach.model.Address;
import rocks.xmpp.extensions.reach.model.Reachability;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class ReachabilityManager
extends AbstractIQHandler
implements InboundPresenceHandler,
OutboundPresenceHandler,
InboundMessageHandler,
ExtensionProtocol,
DiscoverableInfo {
    private static final Set<String> FEATURES = Collections.singleton("urn:xmpp:reach:0");
    private final Set<Consumer<ReachabilityEvent>> reachabilityListeners = new CopyOnWriteArraySet<Consumer<ReachabilityEvent>>();
    private final Map<Jid, List<Address>> reachabilities = new ConcurrentHashMap<Jid, List<Address>>();
    private final List<Address> addresses = new CopyOnWriteArrayList<Address>();
    private final XmppSession xmppSession;

    ReachabilityManager(XmppSession xmppSession) {
        super(Reachability.class, new IQ.Type[]{IQ.Type.GET});
        this.xmppSession = xmppSession;
    }

    public List<Address> getReachabilityAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public boolean addReachabilityAddress(Address address) {
        boolean result = this.addresses.add(address);
        this.xmppSession.enableFeature(this.getNamespace());
        return result;
    }

    public boolean removeReachabilityAddress(Address address) {
        boolean result = this.addresses.remove(address);
        if (this.addresses.isEmpty()) {
            this.xmppSession.disableFeature(this.getNamespace());
        }
        return result;
    }

    public void addReachabilityListener(Consumer<ReachabilityEvent> reachabilityListener) {
        this.reachabilityListeners.add(reachabilityListener);
    }

    public void removeReachabilityListener(Consumer<ReachabilityEvent> reachabilityListener) {
        this.reachabilityListeners.remove(reachabilityListener);
    }

    public AsyncResult<List<Address>> requestReachabilityAddresses(Jid contact) {
        return this.xmppSession.query(IQ.get((Jid)contact, (Object)new Reachability())).thenApply(result -> {
            Reachability reachability = (Reachability)result.getExtension(Reachability.class);
            if (reachability != null) {
                return reachability.getAddresses();
            }
            return null;
        });
    }

    protected final IQ processRequest(IQ iq) {
        return iq.createResult((Object)new Reachability(this.addresses));
    }

    public final void handleInboundPresence(PresenceEvent e) {
        Presence presence = e.getPresence();
        boolean hasReachability = this.checkStanzaForReachabilityAndNotify((Stanza)presence);
        Jid contact = presence.getFrom().asBareJid();
        if (!hasReachability && this.reachabilities.remove(contact) != null) {
            XmppUtils.notifyEventListeners(this.reachabilityListeners, (EventObject)new ReachabilityEvent((Object)this, contact, Collections.emptyList()));
        }
    }

    public final void handleInboundMessage(MessageEvent e) {
        Event event;
        boolean hasReachability = this.checkStanzaForReachabilityAndNotify((Stanza)e.getMessage());
        if (!hasReachability && (event = (Event)e.getMessage().getExtension(Event.class)) != null) {
            for (Item item : event.getItems()) {
                if (!(item.getPayload() instanceof Reachability)) continue;
                this.handleReachability(e.getMessage().getFrom(), (Reachability)item.getPayload());
            }
        }
    }

    private boolean checkStanzaForReachabilityAndNotify(Stanza stanza) {
        Reachability reachability = (Reachability)stanza.getExtension(Reachability.class);
        if (reachability != null && stanza.getFrom() != null) {
            Jid contact = stanza.getFrom().asBareJid();
            this.handleReachability(contact, reachability);
        }
        return reachability != null;
    }

    private void handleReachability(Jid contact, Reachability reachability) {
        List<Address> oldReachabilityAddresses = this.reachabilities.put(contact, reachability.getAddresses());
        if (oldReachabilityAddresses == null || !oldReachabilityAddresses.equals(reachability.getAddresses())) {
            XmppUtils.notifyEventListeners(this.reachabilityListeners, (EventObject)new ReachabilityEvent((Object)this, contact, reachability.getAddresses()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleOutboundPresence(PresenceEvent e) {
        Presence presence = e.getPresence();
        if (presence.isAvailable()) {
            List<Address> list = this.addresses;
            synchronized (list) {
                if (!this.addresses.isEmpty()) {
                    presence.putExtension((Object)new Reachability(new ArrayDeque<Address>(this.addresses)));
                }
            }
        }
    }

    public final String getNamespace() {
        return "urn:xmpp:reach:0";
    }

    public final boolean isEnabled() {
        return !this.addresses.isEmpty();
    }

    public final Set<String> getFeatures() {
        return FEATURES;
    }
}

