/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rpc.client;

import java.util.concurrent.CompletionException;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.extensions.rpc.AbstractRpcManager;
import rocks.xmpp.extensions.rpc.RpcException;
import rocks.xmpp.extensions.rpc.RpcHandler;
import rocks.xmpp.extensions.rpc.model.Rpc;
import rocks.xmpp.extensions.rpc.model.Value;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class ClientRpcManager
extends AbstractRpcManager {
    private final XmppSession xmppSession;

    private ClientRpcManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
    }

    public final synchronized void setRpcHandler(RpcHandler rpcHandler) {
        super.setRpcHandler(rpcHandler);
        if (rpcHandler != null) {
            this.xmppSession.enableFeature(this.getNamespace());
        } else {
            this.xmppSession.disableFeature(this.getNamespace());
        }
    }

    public AsyncResult<Value> call(Jid jid, String methodName, Value ... parameters) {
        AsyncResult query = this.xmppSession.query(IQ.set((Jid)jid, (Object)Rpc.ofMethodCall((String)methodName, (Value[])parameters)));
        return query.thenApply(result -> {
            Rpc.MethodResponse methodResponse;
            Rpc rpc;
            if (result != null && (rpc = (Rpc)result.getExtension(Rpc.class)) != null && (methodResponse = rpc.getMethodResponse()) != null) {
                if (methodResponse.getFault() != null) {
                    throw new CompletionException((Throwable)new RpcException(methodResponse.getFault().getFaultCode(), methodResponse.getFault().getFaultString()));
                }
                return methodResponse.getResponse();
            }
            return null;
        });
    }
}

