/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.avatar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.InboundMessageHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.extensions.address.model.Address;
import rocks.xmpp.extensions.address.model.Addresses;
import rocks.xmpp.extensions.avatar.AbstractAvatarManager;
import rocks.xmpp.extensions.avatar.model.data.AvatarData;
import rocks.xmpp.extensions.avatar.model.metadata.AvatarMetadata;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.pubsub.PubSubManager;
import rocks.xmpp.extensions.pubsub.PubSubService;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.event.Event;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class UserAvatarProtocol
extends AbstractAvatarManager
implements InboundMessageHandler,
ExtensionProtocol,
DiscoverableInfo {
    private static final System.Logger logger = System.getLogger(UserAvatarProtocol.class.getName());

    UserAvatarProtocol(XmppSession xmppSession) {
        super(xmppSession);
    }

    public final String getNamespace() {
        return "urn:xmpp:avatar:data";
    }

    public final boolean isEnabled() {
        return !this.avatarChangeListeners.isEmpty();
    }

    public final Set<String> getFeatures() {
        return Set.of("urn:xmpp:avatar:metadata", "urn:xmpp:avatar:metadata+notify", "urn:xmpp:avatar:data");
    }

    public final void handleInboundMessage(MessageEvent e) {
        Message message = e.getMessage();
        Event event = (Event)message.getExtension(Event.class);
        if (event != null) {
            Addresses addresses = (Addresses)message.getExtension(Addresses.class);
            if (addresses != null) {
                for (Address address : addresses.getAddresses()) {
                    if (address.getType() != Address.Type.REPLYTO || !this.xmppSession.getConnectedResource().equals(address.getJid())) continue;
                    return;
                }
            }
            this.handleMetaData(event.getItems(), message.getFrom().asBareJid()).thenAccept(avatar -> this.notifyListeners(message.getFrom().asBareJid(), (byte[])avatar));
        }
    }

    private CompletionStage<byte[]> handleMetaData(Iterable<Item> metadata, Jid contact) {
        for (Item item : metadata) {
            if (!(item.getPayload() instanceof AvatarMetadata)) continue;
            AvatarMetadata avatarMetadata = (AvatarMetadata)item.getPayload();
            if (avatarMetadata.getInfoList().isEmpty()) {
                return CompletableFuture.completedFuture(new byte[0]);
            }
            byte[] cachedImage = this.loadFromCache(item.getId());
            if (cachedImage != null) {
                return CompletableFuture.completedFuture(cachedImage);
            }
            AvatarMetadata.Info chosenInfo = null;
            for (AvatarMetadata.Info info : avatarMetadata.getInfoList()) {
                if (info.getUrl() != null) continue;
                chosenInfo = info;
            }
            if (chosenInfo == null) {
                for (AvatarMetadata.Info info : avatarMetadata.getInfoList()) {
                    if (info.getUrl() == null) continue;
                    chosenInfo = info;
                    break;
                }
            }
            if (chosenInfo != null && chosenInfo.getUrl() != null) {
                try {
                    URLConnection urlConnection = chosenInfo.getUrl().openConnection();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try (InputStream in = urlConnection.getInputStream();){
                        int n;
                        byte[] data = new byte[4096];
                        while ((n = in.read(data, 0, 4096)) != -1) {
                            baos.write(data, 0, n);
                        }
                    }
                    byte[] data = baos.toByteArray();
                    this.storeToCache(item.getId(), data);
                    return CompletableFuture.completedFuture(data);
                }
                catch (IOException e1) {
                    logger.log(System.Logger.Level.WARNING, "Failed to download avatar from advertised URL: {0}.", chosenInfo.getUrl());
                    continue;
                }
            }
            PubSubService pubSubService = ((PubSubManager)((Object)this.xmppSession.getManager(PubSubManager.class))).createPubSubService(contact.asBareJid());
            return pubSubService.node("urn:xmpp:avatar:data").getItems(item.getId()).thenCompose(items -> {
                Item i;
                if (!items.isEmpty() && (i = (Item)items.get(0)).getPayload() instanceof AvatarData) {
                    AvatarData avatarData = (AvatarData)i.getPayload();
                    this.storeToCache(item.getId(), avatarData.getData());
                    return CompletableFuture.completedFuture(avatarData.getData());
                }
                return CompletableFuture.completedFuture(new byte[0]);
            }).whenComplete((items, ex) -> {
                if (ex != null) {
                    logger.log(System.Logger.Level.WARNING, () -> String.format("Failed to retrieve avatar '%s' from PEP service for user '%s'", item.getId(), contact.asBareJid()));
                }
            });
        }
        return CompletableFuture.completedFuture(new byte[0]);
    }

    @Override
    public final AsyncResult<byte[]> getAvatar(Jid contact) {
        PubSubService pubSubService = ((PubSubManager)((Object)this.xmppSession.getManager(PubSubManager.class))).createPubSubService(contact.asBareJid());
        return pubSubService.node("urn:xmpp:avatar:metadata").getItems(1).thenCompose(items -> this.handleMetaData((Iterable<Item>)items, contact));
    }

    @Override
    public final AsyncResult<Void> publishAvatar(byte[] imageData) {
        String hash = imageData != null ? XmppUtils.hash((byte[])imageData) : null;
        PubSubService personalEventingService = ((PubSubManager)((Object)this.xmppSession.getManager(PubSubManager.class))).createPersonalEventingService();
        AsyncResult publishResult = imageData != null ? personalEventingService.node("urn:xmpp:avatar:data").publish(hash, new AvatarData(imageData)).thenCompose(nodeId -> {
            AvatarMetadata.Info info = new AvatarMetadata.Info((long)imageData.length, hash, "image/png");
            return personalEventingService.node("urn:xmpp:avatar:metadata").publish(hash, new AvatarMetadata(new AvatarMetadata.Info[]{info}));
        }) : personalEventingService.node("urn:xmpp:avatar:metadata").publish(new AvatarMetadata(new AvatarMetadata.Info[0]));
        return publishResult.thenRun(() -> {});
    }
}

