/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.blocking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.blocking.BlockingEvent;
import rocks.xmpp.extensions.blocking.model.Block;
import rocks.xmpp.extensions.blocking.model.BlockList;
import rocks.xmpp.extensions.blocking.model.Blockable;
import rocks.xmpp.extensions.blocking.model.Unblock;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class BlockingManager
extends AbstractIQHandler
implements ExtensionProtocol,
DiscoverableInfo {
    private final Set<Jid> blockedContacts = new HashSet<Jid>();
    private final Set<Consumer<BlockingEvent>> blockingListeners = new CopyOnWriteArraySet<Consumer<BlockingEvent>>();
    private final XmppSession xmppSession;

    BlockingManager(XmppSession xmppSession) {
        super(Blockable.class, new IQ.Type[]{IQ.Type.SET});
        this.xmppSession = xmppSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IQ processRequest(IQ iq) {
        if (iq.getFrom() == null || iq.getFrom().equals(this.xmppSession.getConnectedResource().asBareJid())) {
            Blockable block = (Blockable)iq.getExtension(Blockable.class);
            if (block instanceof Block) {
                ArrayList<Jid> pushedContacts = new ArrayList<Jid>();
                Set<Jid> set = this.blockedContacts;
                synchronized (set) {
                    for (Jid item : block.getItems()) {
                        this.blockedContacts.add(item);
                        pushedContacts.add(item);
                    }
                }
                XmppUtils.notifyEventListeners(this.blockingListeners, (EventObject)new BlockingEvent((Object)this, pushedContacts, Collections.emptyList()));
                return iq.createResult();
            }
            if (block instanceof Unblock) {
                ArrayList<Jid> pushedContacts = new ArrayList<Jid>();
                Set<Jid> set = this.blockedContacts;
                synchronized (set) {
                    if (block.getItems().isEmpty()) {
                        pushedContacts.addAll(this.blockedContacts);
                        this.blockedContacts.clear();
                    } else {
                        for (Jid item : block.getItems()) {
                            this.blockedContacts.remove(item);
                            pushedContacts.add(item);
                        }
                    }
                }
                XmppUtils.notifyEventListeners(this.blockingListeners, (EventObject)new BlockingEvent((Object)this, Collections.emptyList(), pushedContacts));
                return iq.createResult();
            }
        }
        return iq.createError(Condition.NOT_ACCEPTABLE);
    }

    public final void addBlockingListener(Consumer<BlockingEvent> blockingListener) {
        this.blockingListeners.add(blockingListener);
    }

    public final void removeBlockingListener(Consumer<BlockingEvent> blockingListener) {
        this.blockingListeners.remove(blockingListener);
    }

    public final AsyncResult<Set<Jid>> getBlockedContacts() {
        return this.xmppSession.query(IQ.get((Object)new BlockList())).thenApply(result -> {
            BlockList blockList = (BlockList)result.getExtension(BlockList.class);
            if (blockList != null) {
                Set<Jid> set = this.blockedContacts;
                synchronized (set) {
                    this.blockedContacts.addAll(blockList.getItems());
                }
            }
            return this.blockedContacts;
        });
    }

    public final AsyncResult<IQ> blockContact(Jid ... jids) {
        return this.xmppSession.query(IQ.set((Object)new Block(Arrays.asList(jids))));
    }

    public final AsyncResult<IQ> unblockContact(Jid ... jids) {
        return this.xmppSession.query(IQ.set((Object)new Unblock(Arrays.asList(jids))));
    }

    public final String getNamespace() {
        return "urn:xmpp:blocking";
    }

    public final boolean isEnabled() {
        return !this.blockingListeners.isEmpty();
    }

    public final Set<String> getFeatures() {
        return Collections.emptySet();
    }
}

