/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpauth;

import java.util.EventObject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.InboundMessageHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.httpauth.HttpAuthenticationEvent;
import rocks.xmpp.extensions.httpauth.model.ConfirmationRequest;
import rocks.xmpp.util.XmppUtils;

public final class HttpAuthenticationManager
extends AbstractIQHandler
implements InboundMessageHandler,
ExtensionProtocol {
    private final Set<Consumer<HttpAuthenticationEvent>> httpAuthenticationListeners = new CopyOnWriteArraySet<Consumer<HttpAuthenticationEvent>>();
    private final XmppSession xmppSession;

    private HttpAuthenticationManager(XmppSession xmppSession) {
        super(ConfirmationRequest.class, new IQ.Type[]{IQ.Type.GET});
        this.xmppSession = xmppSession;
    }

    public void addHttpAuthenticationListener(Consumer<HttpAuthenticationEvent> httpAuthenticationListener) {
        this.httpAuthenticationListeners.add(httpAuthenticationListener);
    }

    public void removeHttpAuthenticationListener(Consumer<HttpAuthenticationEvent> httpAuthenticationListener) {
        this.httpAuthenticationListeners.remove(httpAuthenticationListener);
    }

    protected IQ processRequest(IQ iq) {
        ConfirmationRequest confirmationRequest = (ConfirmationRequest)iq.getExtension(ConfirmationRequest.class);
        XmppUtils.notifyEventListeners(this.httpAuthenticationListeners, (EventObject)new HttpAuthenticationEvent((Object)this, this.xmppSession, (Stanza)iq, confirmationRequest));
        return this.httpAuthenticationListeners.isEmpty() ? iq.createError(Condition.SERVICE_UNAVAILABLE) : null;
    }

    public void handleInboundMessage(MessageEvent e) {
        ConfirmationRequest confirmationRequest;
        Message message = e.getMessage();
        if ((message.getType() == null || message.getType() == Message.Type.NORMAL) && (confirmationRequest = (ConfirmationRequest)message.getExtension(ConfirmationRequest.class)) != null) {
            XmppUtils.notifyEventListeners(this.httpAuthenticationListeners, (EventObject)new HttpAuthenticationEvent((Object)this, this.xmppSession, (Stanza)message, confirmationRequest));
        }
    }

    public final String getNamespace() {
        return "http://jabber.org/protocol/http-auth";
    }

    public final boolean isEnabled() {
        return !this.httpAuthenticationListeners.isEmpty();
    }
}

