/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.ping;

import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.InboundIQHandler;
import rocks.xmpp.core.stanza.InboundMessageHandler;
import rocks.xmpp.core.stanza.InboundPresenceHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaErrorException;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.ping.handler.PingHandler;
import rocks.xmpp.extensions.ping.model.Ping;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;
import rocks.xmpp.util.concurrent.QueuedScheduledExecutorService;

public final class PingManager
extends Manager
implements ExtensionProtocol,
InboundMessageHandler,
InboundPresenceHandler,
InboundIQHandler,
DiscoverableInfo {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"Scheduled Ping Thread"));
    private final QueuedScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> nextPing;
    private Duration pingInterval = Duration.ofMinutes(15L);
    private final PingHandler iqHandler;

    private PingManager(XmppSession xmppSession) {
        super(xmppSession, true);
        this.scheduledExecutorService = new QueuedScheduledExecutorService((Executor)EXECUTOR_SERVICE);
        this.scheduledExecutorService.setRemoveOnCancelPolicy(true);
        this.iqHandler = new PingHandler();
    }

    protected final void onEnable() {
        super.onEnable();
        this.xmppSession.addIQHandler((IQHandler)this.iqHandler);
        this.rescheduleNextPing();
    }

    protected final void onDisable() {
        super.onDisable();
        this.cancelNextPing();
    }

    public final AsyncResult<Boolean> ping(Jid jid) {
        IQ request = IQ.get((Jid)jid, (Object)Ping.INSTANCE);
        return this.xmppSession.query(request).handle((iq, e) -> {
            if (e != null) {
                Throwable cause;
                Throwable throwable = cause = e instanceof CompletionException ? e.getCause() : e;
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (cause instanceof StanzaErrorException) {
                    if (jid != null && jid.isFullJid()) {
                        Jid from = ((StanzaErrorException)cause).getStanza().getFrom();
                        return from != null && from.isFullJid() && from.equals(jid);
                    }
                    Condition condition = ((StanzaErrorException)cause).getCondition();
                    return condition == Condition.SERVICE_UNAVAILABLE || condition == Condition.FEATURE_NOT_IMPLEMENTED;
                }
            }
            return true;
        });
    }

    public final AsyncResult<Boolean> pingServer() {
        return this.ping(this.xmppSession.getDomain());
    }

    public final synchronized Duration getPingInterval() {
        return this.pingInterval;
    }

    public final synchronized void setPingInterval(Duration pingInterval) {
        this.pingInterval = pingInterval;
        this.rescheduleNextPing();
    }

    private synchronized void rescheduleNextPing() {
        if (this.pingInterval != null && !this.pingInterval.isNegative() && !this.scheduledExecutorService.isShutdown()) {
            this.cancelNextPing();
            this.nextPing = this.scheduledExecutorService.schedule(() -> {
                if (this.isEnabled() && this.xmppSession.getStatus() == XmppSession.Status.AUTHENTICATED) {
                    this.pingServer().thenAccept(result -> {
                        if (!result.booleanValue()) {
                            try {
                                throw new XmppException("Server ping failed.");
                            }
                            catch (XmppException e) {
                                this.xmppSession.notifyException((Throwable)e);
                            }
                        }
                    });
                }
            }, this.pingInterval.getSeconds(), TimeUnit.SECONDS);
        }
    }

    private synchronized void cancelNextPing() {
        if (this.nextPing != null) {
            this.nextPing.cancel(false);
            this.nextPing = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        PingManager pingManager = this;
        synchronized (pingManager) {
            this.cancelNextPing();
            this.scheduledExecutorService.shutdownNow();
        }
    }

    public final String getNamespace() {
        return this.iqHandler.getNamespace();
    }

    public final Set<String> getFeatures() {
        return this.iqHandler.getFeatures();
    }

    public final void handleInboundIQ(IQEvent e) {
        this.rescheduleNextPing();
    }

    public final void handleInboundMessage(MessageEvent e) {
        this.rescheduleNextPing();
    }

    public final void handleInboundPresence(PresenceEvent e) {
        this.rescheduleNextPing();
    }
}

