/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rtt;

import java.text.Normalizer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import rocks.xmpp.core.session.SendTask;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.extensions.rtt.RealTimeMessage;
import rocks.xmpp.extensions.rtt.model.RealTimeText;
import rocks.xmpp.im.chat.Chat;
import rocks.xmpp.util.concurrent.QueuedScheduledExecutorService;

public final class OutboundRealTimeMessage
extends RealTimeMessage {
    private final Collection<RealTimeText.Action> actions = new ArrayDeque<RealTimeText.Action>();
    private final Chat chat;
    private final ScheduledExecutorService transmissionExecutor;
    private final long refreshInterval;
    private final long transmissionInterval;
    private CharSequence text;
    private ScheduledFuture<?> nextRefresh;
    private ScheduledFuture<?> nextTransmission;
    private long lastTextChange;
    private boolean isNew = true;

    OutboundRealTimeMessage(Chat chat, String id, final long transmissionInterval, final long refreshInterval) {
        this.chat = chat;
        this.id = id;
        this.transmissionInterval = transmissionInterval;
        this.refreshInterval = refreshInterval;
        this.transmissionExecutor = new QueuedScheduledExecutorService((Executor)REAL_TIME_TEXT_EXECUTOR);
        this.nextTransmission = this.transmissionExecutor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutboundRealTimeMessage outboundRealTimeMessage = OutboundRealTimeMessage.this;
                synchronized (outboundRealTimeMessage) {
                    if (!OutboundRealTimeMessage.this.actions.isEmpty()) {
                        if (OutboundRealTimeMessage.this.isNew) {
                            OutboundRealTimeMessage.this.sequence.set(OutboundRealTimeMessage.generateSequenceNumber());
                            OutboundRealTimeMessage.this.nextRefresh = OutboundRealTimeMessage.this.transmissionExecutor.schedule(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    OutboundRealTimeMessage outboundRealTimeMessage = OutboundRealTimeMessage.this;
                                    synchronized (outboundRealTimeMessage) {
                                        if (System.currentTimeMillis() - OutboundRealTimeMessage.this.lastTextChange < refreshInterval) {
                                            OutboundRealTimeMessage.this.reset();
                                        }
                                        OutboundRealTimeMessage.this.nextRefresh = OutboundRealTimeMessage.this.transmissionExecutor.schedule(this, refreshInterval, TimeUnit.MILLISECONDS);
                                    }
                                }
                            }, refreshInterval, TimeUnit.MILLISECONDS);
                        }
                        OutboundRealTimeMessage.this.sendRttMessage(OutboundRealTimeMessage.this.isNew ? RealTimeText.Event.NEW : RealTimeText.Event.EDIT);
                        OutboundRealTimeMessage.this.isNew = false;
                    }
                    OutboundRealTimeMessage.this.nextTransmission = OutboundRealTimeMessage.this.transmissionExecutor.schedule(this, transmissionInterval, TimeUnit.MILLISECONDS);
                }
            }
        }, transmissionInterval, TimeUnit.MILLISECONDS);
    }

    private static int generateSequenceNumber() {
        return ThreadLocalRandom.current().nextInt(100000);
    }

    static List<RealTimeText.Action> computeActionElements(CharSequence oldText, CharSequence newText) {
        if (oldText == null && newText == null || oldText != null && newText != null && oldText.toString().contentEquals(newText) || oldText == null && newText.length() == 0 || newText == null && oldText.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> actions = new ArrayList<Object>();
        if (oldText == null) {
            actions.add(new RealTimeText.InsertText(newText));
        } else if (newText == null) {
            actions.add(new RealTimeText.EraseText(Integer.valueOf(oldText.length()), Integer.valueOf(oldText.length())));
        } else {
            int endIndex;
            int lastChangedCharacter;
            int[] bounds = OutboundRealTimeMessage.determineBounds(oldText, newText);
            int firstChangedCharacter = bounds[0];
            int n = Character.codePointCount(oldText, firstChangedCharacter, lastChangedCharacter = bounds[1]);
            if (n > 0) {
                actions.add(new RealTimeText.EraseText(n == 1 ? null : Integer.valueOf(n), lastChangedCharacter == oldText.length() ? null : Integer.valueOf(Character.codePointCount(oldText, 0, lastChangedCharacter))));
            }
            if ((endIndex = newText.length() - oldText.length() + lastChangedCharacter) > firstChangedCharacter) {
                actions.add(new RealTimeText.InsertText(newText.subSequence(firstChangedCharacter, endIndex), firstChangedCharacter == oldText.length() ? null : Integer.valueOf(Character.codePointCount(oldText, 0, firstChangedCharacter))));
            }
        }
        return Collections.unmodifiableList(actions);
    }

    static int[] determineBounds(CharSequence oldText, CharSequence newText) {
        int lastChangedCharacter;
        int firstChangedCharacter;
        for (firstChangedCharacter = 0; firstChangedCharacter < oldText.length() && firstChangedCharacter < newText.length() && oldText.charAt(firstChangedCharacter) == newText.charAt(firstChangedCharacter); ++firstChangedCharacter) {
        }
        for (lastChangedCharacter = 0; lastChangedCharacter < oldText.length() && lastChangedCharacter < newText.length() && firstChangedCharacter < newText.length() && firstChangedCharacter < oldText.length() - lastChangedCharacter && firstChangedCharacter < newText.length() - lastChangedCharacter && oldText.charAt(oldText.length() - 1 - lastChangedCharacter) == newText.charAt(newText.length() - 1 - lastChangedCharacter); ++lastChangedCharacter) {
        }
        return new int[]{firstChangedCharacter, oldText.length() - lastChangedCharacter};
    }

    public final synchronized void update(CharSequence text) {
        if (this.complete) {
            throw new IllegalStateException("Real-time message is already completed.");
        }
        long now = System.currentTimeMillis();
        if (!this.actions.isEmpty() && now != this.lastTextChange) {
            this.actions.add((RealTimeText.Action)new RealTimeText.WaitInterval(now - this.lastTextChange));
        }
        this.lastTextChange = now;
        text = Normalizer.normalize(text, Normalizer.Form.NFC).replace("\r\n", "\n");
        this.actions.addAll(OutboundRealTimeMessage.computeActionElements(this.text, text));
        this.text = text;
    }

    public final synchronized void reset() {
        this.reset(null, this.text);
    }

    public final synchronized void reset(String id, CharSequence text) {
        this.id = id;
        this.text = text;
        this.sequence.set(OutboundRealTimeMessage.generateSequenceNumber());
        this.actions.clear();
        this.actions.add((RealTimeText.Action)new RealTimeText.InsertText(text));
        this.sendRttMessage(RealTimeText.Event.RESET);
    }

    @Override
    public final synchronized String getText() {
        return this.text != null ? this.text.toString() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SendTask<Message> commit() {
        if (this.complete) {
            throw new IllegalStateException("Already committed.");
        }
        SendTask message = this.chat.sendMessage(this.getText());
        this.complete = true;
        OutboundRealTimeMessage outboundRealTimeMessage = this;
        synchronized (outboundRealTimeMessage) {
            if (this.nextRefresh != null) {
                this.nextRefresh.cancel(false);
            }
            if (this.nextTransmission != null) {
                this.nextTransmission.cancel(false);
            }
        }
        this.transmissionExecutor.shutdown();
        return message;
    }

    private void sendRttMessage(RealTimeText.Event event) {
        Message message = new Message();
        RealTimeText realTimeText = new RealTimeText(event, this.actions, this.sequence.getAndIncrement(), this.id);
        message.addExtension((Object)realTimeText);
        this.chat.sendMessage(message);
        this.actions.clear();
    }

    public final long getRefreshInterval() {
        return this.refreshInterval;
    }

    public final long getTransmissionInterval() {
        return this.transmissionInterval;
    }
}

