/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.version.client;

import java.io.InputStream;
import java.util.Properties;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.extensions.version.SoftwareVersionManager;
import rocks.xmpp.extensions.version.SoftwareVersionProtocol;
import rocks.xmpp.extensions.version.model.SoftwareVersion;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class ClientSoftwareVersionManager
extends SoftwareVersionProtocol
implements SoftwareVersionManager {
    private static final SoftwareVersion DEFAULT_VERSION;
    private final XmppSession xmppSession;

    private ClientSoftwareVersionManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        this.setSoftwareInfo(DEFAULT_VERSION);
    }

    public AsyncResult<SoftwareVersion> getSoftwareVersion(Jid jid) {
        return this.xmppSession.query(IQ.get((Jid)jid, (Object)new SoftwareVersion()), SoftwareVersion.class);
    }

    public SoftwareVersion getSoftwareVersion() {
        return this.getSoftwareInfo();
    }

    public void setSoftwareVersion(SoftwareVersion softwareVersion) {
        this.setSoftwareInfo(softwareVersion);
    }

    public synchronized void setSoftwareInfo(SoftwareVersion softwareVersion) {
        super.setSoftwareInfo(softwareVersion);
        if (softwareVersion != null) {
            this.xmppSession.enableFeature(this.getNamespace());
        } else {
            this.xmppSession.disableFeature(this.getNamespace());
        }
    }

    static {
        SoftwareVersion version;
        Properties properties = new Properties();
        try (InputStream inputStream = ClientSoftwareVersionManager.class.getResourceAsStream("/META-INF/maven/rocks.xmpp/xmpp-extensions-client/pom.properties");){
            properties.load(inputStream);
            version = new SoftwareVersion("Babbler", properties.getProperty("version"));
        }
        catch (Exception e) {
            version = null;
        }
        DEFAULT_VERSION = version;
    }
}

