/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle.transports.s5b.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.bytestreams.s5b.model.Socks5ByteStream;
import rocks.xmpp.extensions.bytestreams.s5b.model.Socks5StreamHost;
import rocks.xmpp.extensions.jingle.transports.model.TransportMethod;

@XmlRootElement(name="transport")
public final class S5bTransportMethod
extends TransportMethod {
    public static final String NAMESPACE = "urn:xmpp:jingle:transports:s5b:1";
    @XmlAttribute
    private final String sid;
    @XmlAttribute
    private final String dstaddr;
    @XmlAttribute
    private final Socks5ByteStream.Mode mode;
    private final List<Candidate> candidate = new ArrayList<Candidate>();
    @XmlElement(name="candidate-used")
    private final CandidateUsed candidateUsed;
    private final Activated activated;
    @XmlElement(name="candidate-error")
    private final String candidateError;
    @XmlElement(name="proxy-error")
    private final String proxyError;

    private S5bTransportMethod() {
        this(null, null, null, Collections.emptyList());
    }

    public S5bTransportMethod(String sessionId, String dstaddr, Socks5ByteStream.Mode mode, Collection<Candidate> candidates) {
        this(sessionId, dstaddr, mode, candidates, null, null, false, false);
    }

    private S5bTransportMethod(String sessionId, String dstaddr, Socks5ByteStream.Mode mode, Collection<Candidate> candidates, CandidateUsed candidateUsed, Activated activated, boolean candidateError, boolean proxyError) {
        this.sid = sessionId;
        this.dstaddr = dstaddr;
        this.mode = mode;
        this.candidate.addAll(candidates);
        this.candidateUsed = candidateUsed;
        this.activated = activated;
        this.candidateError = candidateError ? "" : null;
        this.proxyError = proxyError ? "" : null;
    }

    public static S5bTransportMethod candidateUsed(String sid, String cid) {
        return new S5bTransportMethod(sid, null, null, Collections.emptyList(), new CandidateUsed(cid), null, false, false);
    }

    public static S5bTransportMethod candidateError(String sid) {
        return new S5bTransportMethod(sid, null, null, Collections.emptyList(), null, null, true, false);
    }

    public static S5bTransportMethod proxyError(String sid) {
        return new S5bTransportMethod(sid, null, null, Collections.emptyList(), null, null, false, true);
    }

    public static S5bTransportMethod activated(String sid, String cid) {
        return new S5bTransportMethod(sid, null, null, Collections.emptyList(), null, new Activated(cid), false, false);
    }

    public static int calculatePriority(Candidate.Type type, int localPreference) {
        return 65535 * (type == null ? Candidate.Type.DIRECT.getPreferenceValue() : type.getPreferenceValue()) + localPreference;
    }

    public final String getDstAddr() {
        return this.dstaddr;
    }

    public final String getSessionId() {
        return this.sid;
    }

    public final Socks5ByteStream.Mode getMode() {
        return this.mode;
    }

    public final List<Candidate> getCandidates() {
        return Collections.unmodifiableList(this.candidate);
    }

    public final String getCandidateUsed() {
        return this.candidateUsed != null ? this.candidateUsed.cid : null;
    }

    public final String getActivated() {
        return this.activated != null ? this.activated.cid : null;
    }

    public final boolean isCandidateError() {
        return this.candidateError != null;
    }

    public final boolean isProxyError() {
        return this.proxyError != null;
    }

    private static final class Activated {
        @XmlAttribute
        private final String cid;

        private Activated() {
            this.cid = null;
        }

        public Activated(String cid) {
            this.cid = Objects.requireNonNull(cid);
        }
    }

    private static final class CandidateUsed {
        @XmlAttribute
        private final String cid;

        private CandidateUsed() {
            this.cid = null;
        }

        public CandidateUsed(String cid) {
            this.cid = Objects.requireNonNull(cid);
        }
    }

    public static final class Candidate
    implements Socks5StreamHost,
    Comparable<Candidate> {
        @XmlAttribute
        private final String cid;
        @XmlAttribute
        private final String host;
        @XmlAttribute
        private final Jid jid;
        @XmlAttribute
        private final int port;
        @XmlAttribute
        private final int priority;
        @XmlAttribute
        private final Type type;

        private Candidate() {
            this(null, null, 0, null, null, 0);
        }

        public Candidate(String cid, String hostname, int port, Jid jid, Type type, int priority) {
            this.cid = cid;
            this.host = hostname;
            this.jid = jid;
            this.type = type;
            this.port = port;
            this.priority = priority;
        }

        public final String getCid() {
            return this.cid;
        }

        @Override
        public final String getHostname() {
            return this.host;
        }

        @Override
        public final Jid getJid() {
            return this.jid;
        }

        @Override
        public final int getPort() {
            return this.port;
        }

        public final int getPriority() {
            return this.priority;
        }

        public final Type getType() {
            return this.type;
        }

        @Override
        public final int compareTo(Candidate o) {
            return Integer.compare(o.priority, this.priority);
        }

        public static enum Type {
            DIRECT(126),
            ASSISTED(120),
            TUNNEL(110),
            PROXY(10);

            private final int preferenceValue;

            private Type(int preferenceValue) {
                this.preferenceValue = preferenceValue;
            }

            public final int getPreferenceValue() {
                return this.preferenceValue;
            }
        }
    }
}

