/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.register.model;

import java.net.URI;
import java.net.URL;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.oob.model.x.OobX;

@XmlRootElement(name="query")
public final class Registration {
    public static final String NAMESPACE = "jabber:iq:register";
    private final String registered;
    private final String instructions;
    private final String username;
    private final String nick;
    private final String password;
    private final String name;
    @XmlElement(name="first")
    private final String givenName;
    @XmlElement(name="last")
    private final String familyName;
    private final String email;
    @XmlElement(name="address")
    private final String street;
    private final String city;
    private final String region;
    @XmlElement(name="zip")
    private final String postalCode;
    @XmlElement(name="phone")
    private final String telephone;
    private final URL url;
    private final String date;
    private final String remove;
    @XmlElementRef
    private final DataForm dataForm;
    @XmlElementRef
    private final OobX oobX;

    private Registration() {
        this(false);
    }

    private Registration(Builder builder) {
        this.registered = builder.registered ? "" : null;
        this.instructions = builder.instructions;
        this.username = builder.username;
        this.nick = builder.nickname;
        this.password = builder.password;
        this.name = builder.name;
        this.givenName = builder.givenName;
        this.familyName = builder.familyName;
        this.email = builder.email;
        this.street = builder.street;
        this.city = builder.city;
        this.region = builder.region;
        this.postalCode = builder.postalCode;
        this.telephone = builder.phone;
        this.url = builder.url;
        this.date = builder.date;
        this.dataForm = builder.dataForm;
        this.oobX = builder.oobX;
        this.remove = null;
    }

    private Registration(boolean remove) {
        this.registered = null;
        this.instructions = null;
        this.username = null;
        this.nick = null;
        this.password = null;
        this.name = null;
        this.givenName = null;
        this.familyName = null;
        this.email = null;
        this.street = null;
        this.city = null;
        this.region = null;
        this.postalCode = null;
        this.telephone = null;
        this.url = null;
        this.date = null;
        this.dataForm = null;
        this.oobX = null;
        this.remove = remove ? "" : null;
    }

    public static Registration remove() {
        return new Registration(true);
    }

    public static Registration empty() {
        return new Registration(false);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isRegistered() {
        return this.registered != null;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public String getUsername() {
        return this.username;
    }

    public String getNickname() {
        return this.nick;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFullName() {
        return this.name;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getLastName() {
        return this.familyName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getStreet() {
        return this.street;
    }

    public String getCity() {
        return this.city;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getDate() {
        return this.date;
    }

    public DataForm getRegistrationForm() {
        return this.dataForm;
    }

    @Deprecated
    public URL getWebRegistrationUrl() {
        return this.oobX != null ? this.oobX.getUrl() : null;
    }

    public URI getWebRegistrationUri() {
        return this.oobX != null ? this.oobX.getUri() : null;
    }

    public boolean isRemove() {
        return this.remove != null;
    }

    public static final class Builder {
        private String instructions;
        private String username;
        private String password;
        private String nickname;
        private String name;
        private String givenName;
        private String familyName;
        private String email;
        private String street;
        private String city;
        private String region;
        private String postalCode;
        private String phone;
        private URL url;
        private String date;
        private DataForm dataForm;
        private OobX oobX;
        private boolean registered;

        private Builder() {
        }

        public Builder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder nickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder street(String street) {
            this.street = street;
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public Builder url(URL url) {
            this.url = url;
            return this;
        }

        public Builder date(String date) {
            this.date = date;
            return this;
        }

        public Builder registrationForm(DataForm dataForm) {
            this.dataForm = dataForm;
            return this;
        }

        public Builder webRegistration(URI uri) {
            this.oobX = new OobX(uri);
            return this;
        }

        public Builder registered(boolean registered) {
            this.registered = registered;
            return this;
        }

        public Registration build() {
            return new Registration(this);
        }
    }
}

