/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rtt.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement(name="rtt")
public final class RealTimeText {
    public static final String NAMESPACE = "urn:xmpp:rtt:0";
    @XmlElements(value={@XmlElement(name="t", type=InsertText.class), @XmlElement(name="e", type=EraseText.class), @XmlElement(name="w", type=WaitInterval.class)})
    private final List<Action> actions = new ArrayList<Action>();
    @XmlAttribute(name="seq")
    private final Integer sequence;
    @XmlAttribute(name="event")
    private final Event event;
    @XmlAttribute(name="id")
    private final String id;

    private RealTimeText() {
        this.event = null;
        this.sequence = null;
        this.id = null;
    }

    public RealTimeText(Event event, Collection<Action> actions, int sequence, String id) {
        this.event = event;
        this.actions.addAll(actions);
        this.sequence = sequence;
        this.id = id;
    }

    public final Event getEvent() {
        return this.event;
    }

    public final Integer getSequence() {
        return this.sequence;
    }

    public final List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public final String getId() {
        return this.id;
    }

    public static final class WaitInterval
    extends Action {
        @XmlAttribute(name="n")
        private final Long milliSeconds;

        private WaitInterval() {
            this.milliSeconds = null;
        }

        public WaitInterval(long milliSeconds) {
            this.milliSeconds = milliSeconds;
        }

        public final Long getMilliSeconds() {
            return this.milliSeconds;
        }

        public final String toString() {
            return "Wait " + this.milliSeconds + " ms";
        }
    }

    public static final class EraseText
    extends Action {
        @XmlAttribute(name="p")
        private final Integer position;
        @XmlAttribute(name="n")
        private final Integer numberOfCharacters;

        public EraseText() {
            this.position = null;
            this.numberOfCharacters = null;
        }

        public EraseText(Integer n) {
            if (n != null && n < 0) {
                throw new IllegalArgumentException("n must not be < 0");
            }
            this.position = null;
            this.numberOfCharacters = n;
        }

        public EraseText(Integer n, Integer p) {
            if (n != null && n < 0) {
                throw new IllegalArgumentException("n must not be < 0");
            }
            if (p != null && p < 0) {
                throw new IllegalArgumentException("p must not be < 0");
            }
            this.position = p;
            this.numberOfCharacters = n;
        }

        public final Integer getPosition() {
            return this.position;
        }

        public final Integer getNumberOfCharacters() {
            return this.numberOfCharacters;
        }

        public final String toString() {
            return "Erase " + (this.numberOfCharacters != null ? this.numberOfCharacters : 1) + " character(s) at " + (this.position != null ? "position " + this.position : "last position");
        }
    }

    public static final class InsertText
    extends Action {
        @XmlValue
        private final String text;
        @XmlAttribute(name="p")
        private final Integer position;

        private InsertText() {
            this.text = null;
            this.position = null;
        }

        public InsertText(CharSequence text) {
            this.text = text.toString();
            this.position = null;
        }

        public InsertText(CharSequence text, Integer position) {
            if (position != null && position < 0) {
                throw new IllegalArgumentException("position must not be < 0");
            }
            this.text = text.toString();
            this.position = position;
        }

        public final String getText() {
            return this.text;
        }

        public final Integer getPosition() {
            return this.position;
        }

        public final String toString() {
            return "Insert '" + (this.text != null ? this.text : "") + "'" + (this.position != null ? " at position " + this.position : "");
        }
    }

    @XmlTransient
    public static abstract class Action {
    }

    public static enum Event {
        NEW,
        RESET,
        EDIT,
        INIT,
        CANCEL;

    }
}

