/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.langtrans.model.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.addr.Jid;

@XmlRootElement(name="query")
public final class LanguageSupport {
    @XmlElement
    private final List<Item> item = new ArrayList<Item>();

    public LanguageSupport() {
    }

    public LanguageSupport(Collection<Item> items) {
        this.item.addAll(items);
    }

    public final List<Item> getItems() {
        return Collections.unmodifiableList(this.item);
    }

    public static final class Item {
        @XmlAttribute(name="source_lang")
        private final Locale sourceLanguage;
        @XmlAttribute(name="destination_lang")
        private final Locale destinationLanguage;
        @XmlAttribute
        private final Jid jid;
        @XmlAttribute
        private final String engine;
        @XmlAttribute
        private final Boolean pivotable;
        @XmlAttribute
        private final String dictionary;

        private Item() {
            this.sourceLanguage = null;
            this.jid = null;
            this.destinationLanguage = null;
            this.engine = null;
            this.pivotable = null;
            this.dictionary = null;
        }

        public Item(Locale sourceLanguage, Jid jid) {
            this(sourceLanguage, jid, null, null, null, null);
        }

        public Item(Locale sourceLanguage, Jid jid, Locale destinationLanguage, String engine, Boolean pivotable, String dictionary) {
            this.sourceLanguage = Objects.requireNonNull(sourceLanguage);
            this.jid = Objects.requireNonNull(jid);
            this.destinationLanguage = destinationLanguage;
            this.engine = engine;
            this.pivotable = pivotable;
            this.dictionary = dictionary;
        }

        public final Locale getSourceLanguage() {
            return this.sourceLanguage;
        }

        public final Jid getJid() {
            return this.jid;
        }

        public final Locale getDestinationLanguage() {
            return this.destinationLanguage;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final boolean isPivotable() {
            return this.pivotable != null && this.pivotable != false;
        }

        public final String getDictionary() {
            return this.dictionary;
        }
    }
}

