/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb.model;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;

@XmlTransient
@XmlSeeAlso(value={Open.class, Data.class, Close.class})
public abstract class InBandByteStream {
    public static final String NAMESPACE = "http://jabber.org/protocol/ibb";
    @XmlAttribute
    private final String sid;

    private InBandByteStream(String sid) {
        this.sid = Objects.requireNonNull(sid);
    }

    private InBandByteStream() {
        this.sid = null;
    }

    public final String getSessionId() {
        return this.sid;
    }

    @XmlRootElement
    public static final class Close
    extends InBandByteStream {
        private Close() {
        }

        public Close(String sessionId) {
            super(sessionId);
        }

        public final String toString() {
            return "IBB close (" + this.getSessionId() + ')';
        }
    }

    @XmlRootElement
    public static final class Data
    extends InBandByteStream {
        @XmlAttribute
        private final int seq;
        @XmlValue
        private final byte[] bytes;

        private Data() {
            this.seq = 0;
            this.bytes = null;
        }

        public Data(byte[] bytes, String sid, int seq) {
            super(sid);
            this.bytes = (byte[])Objects.requireNonNull(bytes).clone();
            this.seq = seq;
        }

        public final int getSequence() {
            return this.seq;
        }

        public final byte[] getBytes() {
            return (byte[])this.bytes.clone();
        }

        public final String toString() {
            return "IBB data (" + this.getSessionId() + "), " + this.bytes.length + " bytes, seq: " + this.seq;
        }
    }

    @XmlRootElement
    public static final class Open
    extends InBandByteStream {
        @XmlAttribute(name="block-size")
        private final int blockSize;
        @XmlAttribute
        private final StanzaType stanza;

        private Open() {
            this.blockSize = 0;
            this.stanza = null;
        }

        public Open(int blockSize, String sessionId) {
            this(blockSize, sessionId, null);
        }

        public Open(int blockSize, String sessionId, StanzaType stanzaType) {
            super(sessionId);
            this.blockSize = blockSize;
            this.stanza = stanzaType;
        }

        public final int getBlockSize() {
            return this.blockSize;
        }

        public final StanzaType getStanzaType() {
            return this.stanza;
        }

        public final String toString() {
            return "IBB open (" + this.getSessionId() + "), block-size: " + this.blockSize;
        }

        public static enum StanzaType {
            IQ,
            MESSAGE;

        }
    }
}

