/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.idle.model;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.extensions.delay.model.DelayedDelivery;
import rocks.xmpp.extensions.last.model.LastActivity;
import rocks.xmpp.util.adapters.OffsetDateTimeAdapter;

@XmlRootElement
public final class Idle {
    public static final String NAMESPACE = "urn:xmpp:idle:1";
    @XmlAttribute
    @XmlJavaTypeAdapter(value=OffsetDateTimeAdapter.class)
    private final OffsetDateTime since;

    private Idle() {
        this.since = null;
    }

    private Idle(OffsetDateTime since) {
        this.since = since;
    }

    public static Idle since(OffsetDateTime since) {
        return new Idle(Objects.requireNonNull(since));
    }

    public static Instant timeFromPresence(Presence presence) {
        Idle idle = (Idle)presence.getExtension(Idle.class);
        if (idle != null) {
            return idle.getSince().toInstant();
        }
        LastActivity lastActivity = (LastActivity)presence.getExtension(LastActivity.class);
        if (lastActivity != null && EnumSet.of(Presence.Show.AWAY, Presence.Show.XA).contains(presence.getShow())) {
            return DelayedDelivery.sendDate((Stanza)presence).minusSeconds(lastActivity.getSeconds());
        }
        return null;
    }

    public final OffsetDateTime getSince() {
        return this.since;
    }

    public final String toString() {
        return "Idle since " + this.since;
    }
}

