/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.pubsub.model.Affiliation;
import rocks.xmpp.extensions.pubsub.model.AffiliationState;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.SubscriptionState;
import rocks.xmpp.extensions.pubsub.model.errors.ClosedNode;
import rocks.xmpp.extensions.pubsub.model.errors.ConfigurationRequired;
import rocks.xmpp.extensions.pubsub.model.errors.InvalidJid;
import rocks.xmpp.extensions.pubsub.model.errors.InvalidOptions;
import rocks.xmpp.extensions.pubsub.model.errors.InvalidPayload;
import rocks.xmpp.extensions.pubsub.model.errors.InvalidSubId;
import rocks.xmpp.extensions.pubsub.model.errors.ItemForbidden;
import rocks.xmpp.extensions.pubsub.model.errors.ItemRequired;
import rocks.xmpp.extensions.pubsub.model.errors.JidRequired;
import rocks.xmpp.extensions.pubsub.model.errors.MaxItemsExceeded;
import rocks.xmpp.extensions.pubsub.model.errors.MaxNodesExceeded;
import rocks.xmpp.extensions.pubsub.model.errors.NodeIdRequired;
import rocks.xmpp.extensions.pubsub.model.errors.NotInRosterGroup;
import rocks.xmpp.extensions.pubsub.model.errors.NotSubscribed;
import rocks.xmpp.extensions.pubsub.model.errors.PayloadRequired;
import rocks.xmpp.extensions.pubsub.model.errors.PayloadTooBig;
import rocks.xmpp.extensions.pubsub.model.errors.PendingSubscription;
import rocks.xmpp.extensions.pubsub.model.errors.PresenceSubscriptionRequired;
import rocks.xmpp.extensions.pubsub.model.errors.SubIdRequired;
import rocks.xmpp.extensions.pubsub.model.errors.TooManySubscriptions;
import rocks.xmpp.extensions.pubsub.model.errors.Unsupported;
import rocks.xmpp.extensions.pubsub.model.event.Event;
import rocks.xmpp.extensions.pubsub.model.owner.PubSubOwner;
import rocks.xmpp.util.adapters.InstantAdapter;

@XmlRootElement(name="pubsub")
@XmlSeeAlso(value={Unsupported.class, InvalidJid.class, PresenceSubscriptionRequired.class, NotInRosterGroup.class, ClosedNode.class, PendingSubscription.class, TooManySubscriptions.class, ConfigurationRequired.class, SubIdRequired.class, NotSubscribed.class, NotSubscribed.class, InvalidSubId.class, JidRequired.class, InvalidOptions.class, PayloadTooBig.class, InvalidPayload.class, ItemRequired.class, PayloadRequired.class, ItemForbidden.class, NodeIdRequired.class, MaxItemsExceeded.class, MaxNodesExceeded.class, Event.class, PubSubOwner.class})
public final class PubSub {
    public static final String NAMESPACE = "http://jabber.org/protocol/pubsub";
    private Create create;
    private Configure configure;
    private Subscribe subscribe;
    private Options options;
    @XmlElements(value={@XmlElement(name="affiliations", type=AffiliationsElement.class), @XmlElement(name="default", type=Default.class), @XmlElement(name="items", type=Items.class), @XmlElement(name="publish", type=Publish.class), @XmlElement(name="retract", type=Retract.class), @XmlElement(name="subscription", type=SubscriptionInfo.class), @XmlElement(name="subscriptions", type=Subscriptions.class), @XmlElement(name="unsubscribe", type=Unsubscribe.class)})
    private PubSubChildElement type;
    @XmlElement(name="publish-options")
    private PublishOptions publishOptions;

    private PubSub() {
    }

    private PubSub(Create create, Configure configure) {
        this.create = create;
        this.configure = configure;
    }

    private PubSub(Subscribe subscribe, Options options) {
        this.subscribe = subscribe;
        this.options = options;
    }

    private PubSub(Options options) {
        this.options = options;
    }

    private PubSub(PubSubChildElement pubSubChildElement) {
        this.type = pubSubChildElement;
    }

    private PubSub(Publish publish, PublishOptions publishOptions) {
        this.type = publish;
        this.publishOptions = publishOptions;
    }

    private PubSub(Configure configure) {
        this.configure = configure;
    }

    private PubSub(Subscribe subscribe) {
        this.subscribe = subscribe;
    }

    public static PubSub withAffiliations() {
        return PubSub.withAffiliations(null);
    }

    public static PubSub withAffiliations(String node) {
        return new PubSub(new AffiliationsElement(node));
    }

    public static PubSub withConfigure(String node, DataForm configurationForm) {
        return new PubSub(new Configure(node, configurationForm));
    }

    public static PubSub withCreate(String node) {
        return new PubSub(new Create(node), null);
    }

    public static PubSub withCreate(String node, DataForm configurationForm) {
        return new PubSub(new Create(node), new Configure(configurationForm));
    }

    public static PubSub withSubscriptions() {
        return PubSub.withSubscriptions(null);
    }

    public static PubSub withSubscriptions(String node) {
        return new PubSub(new Subscriptions(node));
    }

    public static PubSub withSubscribe(String node, Jid jid) {
        return new PubSub(new Subscribe(node, jid));
    }

    public static PubSub withSubscribe(String node, Jid jid, DataForm dataForm) {
        return new PubSub(new Subscribe(node, jid), dataForm != null ? new Options(dataForm) : null);
    }

    public static PubSub withOptions(String node, Jid jid, String subid, DataForm dataForm) {
        return new PubSub(new Options(node, jid, subid, dataForm));
    }

    public static PubSub withUnsubscribe(String node, Jid jid, String subscriptionId) {
        return new PubSub(new Unsubscribe(node, jid, subscriptionId));
    }

    public static PubSub withDefault() {
        return PubSub.withDefault(null);
    }

    public static PubSub withDefault(String node) {
        return new PubSub(new Default(node));
    }

    public static PubSub withItems(String node) {
        return new PubSub(new Items(node));
    }

    public static PubSub withItems(String node, String ... ids) {
        ArrayList<ItemElement> items = new ArrayList<ItemElement>();
        for (String id : ids) {
            items.add(new ItemElement(id));
        }
        return new PubSub(new Items(node, items));
    }

    public static PubSub withItems(String node, int maxItems) {
        return new PubSub(new Items(node, maxItems));
    }

    public static PubSub withPublish(String node, String id, Object item, DataForm options) {
        return new PubSub(new Publish(node, new ItemElement(id, item)), options != null ? new PublishOptions(options) : null);
    }

    public static PubSub withRetract(String node, String id, boolean notify) {
        return new PubSub(new Retract(node, new ItemElement(id), notify));
    }

    public final Default getDefault() {
        if (this.type instanceof Default) {
            return (Default)this.type;
        }
        return null;
    }

    public final Subscription getSubscription() {
        if (this.type instanceof SubscriptionInfo) {
            return (SubscriptionInfo)this.type;
        }
        return null;
    }

    public final Options getOptions() {
        return this.options;
    }

    public final List<Item> getItems() {
        if (this.type instanceof Items) {
            return Collections.unmodifiableList(new ArrayList(((Items)this.type).item));
        }
        return null;
    }

    public final Publish getPublish() {
        if (this.type instanceof Publish) {
            return (Publish)this.type;
        }
        return null;
    }

    public final DataForm getConfigurationForm() {
        if (this.configure != null) {
            return this.configure.dataForm;
        }
        return null;
    }

    public final List<Subscription> getSubscriptions() {
        if (this.type instanceof Subscriptions) {
            return Collections.unmodifiableList(new ArrayList(((Subscriptions)this.type).subscription));
        }
        return null;
    }

    public final List<Affiliation> getAffiliations() {
        if (this.type instanceof AffiliationsElement) {
            return Collections.unmodifiableList(new ArrayList(((AffiliationsElement)this.type).affiliation));
        }
        return null;
    }

    public final String getNode() {
        if (this.type != null) {
            return this.type.getNode();
        }
        if (this.create != null) {
            return this.create.getNode();
        }
        if (this.subscribe != null) {
            return this.subscribe.getNode();
        }
        return null;
    }

    public final DataForm getPublishOptions() {
        return this.publishOptions != null ? this.publishOptions.dataForm : null;
    }

    @XmlTransient
    private static abstract class PubSubChildElement {
        @XmlAttribute
        private final String node;

        private PubSubChildElement() {
            this((String)null);
        }

        private PubSubChildElement(String node) {
            this.node = node;
        }

        public final String getNode() {
            return this.node;
        }
    }

    private static final class ItemElement
    implements Item {
        @XmlAnyElement(lax=true)
        private final Object object;
        @XmlAttribute
        private final String id;

        private ItemElement() {
            this(null, (Object)null);
        }

        private ItemElement(String id) {
            this(id, (Object)null);
        }

        private ItemElement(String id, Object object) {
            this.id = id;
            this.object = object;
        }

        @Override
        public final Object getPayload() {
            return this.object;
        }

        @Override
        public final String getId() {
            return this.id;
        }

        @Override
        public final String getNode() {
            return null;
        }

        @Override
        public final String getPublisher() {
            return null;
        }
    }

    private static final class Configure
    extends PubSubChildElement {
        @XmlElementRef
        private final DataForm dataForm;

        private Configure() {
            this((String)null, (DataForm)null);
        }

        private Configure(String node, DataForm dataForm) {
            super(node);
            this.dataForm = dataForm;
        }

        private Configure(DataForm dataForm) {
            this(null, dataForm);
        }
    }

    private static final class Unsubscribe
    extends PubSubChildElement {
        @XmlAttribute
        private final Jid jid;
        @XmlAttribute
        private final String subid;

        private Unsubscribe() {
            this(null, null, null);
        }

        private Unsubscribe(String node, Jid jid, String subid) {
            super(node);
            this.jid = jid;
            this.subid = subid;
        }
    }

    private static final class Subscriptions
    extends PubSubChildElement {
        private final List<SubscriptionInfo> subscription = new ArrayList<SubscriptionInfo>();

        private Subscriptions() {
        }

        private Subscriptions(String node) {
            super(node);
        }
    }

    private static final class SubscriptionInfo
    extends PubSubChildElement
    implements Subscription {
        @XmlAttribute
        private final Jid jid;
        @XmlAttribute
        private final String subid;
        @XmlAttribute
        private final SubscriptionState subscription;
        @XmlAttribute
        @XmlJavaTypeAdapter(value=InstantAdapter.class)
        private final Instant expiry;
        @XmlElement(name="subscribe-options")
        private final SubscribeOptions options;

        private SubscriptionInfo() {
            this(null, null, null, null, null, null);
        }

        private SubscriptionInfo(String node, Jid jid, String subid, SubscriptionState subscription, Instant expiry, SubscribeOptions options) {
            super(node);
            this.jid = jid;
            this.subid = subid;
            this.subscription = subscription;
            this.expiry = expiry;
            this.options = options;
        }

        @Override
        public final String getSubId() {
            return this.subid;
        }

        @Override
        public final SubscriptionState getSubscriptionState() {
            return this.subscription;
        }

        @Override
        public final Jid getJid() {
            return this.jid;
        }

        @Override
        public final Instant getExpiry() {
            return this.expiry;
        }

        @Override
        public final boolean isConfigurationRequired() {
            return this.options != null && this.options.isRequired();
        }

        @Override
        public final boolean isConfigurationSupported() {
            return this.options != null;
        }

        private static final class SubscribeOptions {
            private final String required;

            private SubscribeOptions() {
                this.required = null;
            }

            private SubscribeOptions(boolean required) {
                this.required = required ? "" : null;
            }

            private boolean isRequired() {
                return this.required != null;
            }
        }
    }

    private static final class Retract
    extends PubSubChildElement {
        @XmlAttribute
        private final Boolean notify;
        private final ItemElement item;
        @XmlAttribute
        private final String id;

        private Retract() {
            this(null, null, null);
        }

        private Retract(String node, ItemElement item, Boolean notify) {
            super(node);
            this.item = item;
            this.notify = notify;
            this.id = null;
        }
    }

    private static final class PublishOptions
    extends PubSubChildElement {
        @XmlElementRef
        private final DataForm dataForm;

        private PublishOptions() {
            this((DataForm)null);
        }

        public PublishOptions(DataForm dataForm) {
            this.dataForm = dataForm;
        }
    }

    public static final class Publish
    extends PubSubChildElement {
        private final ItemElement item;

        private Publish() {
            this((String)null, (ItemElement)null);
        }

        private Publish(String node, ItemElement item) {
            super(node);
            this.item = item;
        }

        public final Item getItem() {
            return this.item;
        }
    }

    private static final class Items
    extends PubSubChildElement {
        private final List<ItemElement> item = new ArrayList<ItemElement>();
        @XmlAttribute(name="max_items")
        private final Integer maxItems;
        @XmlAttribute
        private final String subid;
        private final Retract retract;

        private Items() {
            this((String)null);
        }

        private Items(String node) {
            this(node, Collections.emptyList());
        }

        private Items(String node, int maxItems) {
            super(node);
            this.maxItems = maxItems;
            this.subid = null;
            this.retract = null;
        }

        private Items(String node, List<ItemElement> items) {
            super(node);
            this.maxItems = null;
            this.item.addAll(items);
            this.subid = null;
            this.retract = null;
        }
    }

    public static final class Default
    extends PubSubChildElement {
        @XmlAttribute
        private final Type type = null;
        @XmlElementRef
        private final DataForm dataForm = null;

        public Default() {
            this((String)null);
        }

        private Default(String node) {
            super(node);
        }

        public final DataForm getDataForm() {
            return this.dataForm;
        }

        private static enum Type {
            COLLECTION,
            LEAF;

        }
    }

    private static final class AffiliationsElement
    extends PubSubChildElement {
        private final List<AffiliationInfo> affiliation = new ArrayList<AffiliationInfo>();

        private AffiliationsElement() {
        }

        private AffiliationsElement(String node) {
            super(node);
        }

        private static final class AffiliationInfo
        extends PubSubChildElement
        implements Affiliation {
            @XmlAttribute
            private final AffiliationState affiliation;
            @XmlAttribute
            private final Jid jid;

            @Override
            public final Jid getJid() {
                return this.jid;
            }

            private AffiliationInfo() {
                this((Jid)null, (AffiliationState)null);
            }

            private AffiliationInfo(Jid jid, AffiliationState affiliation) {
                this.jid = jid;
                this.affiliation = affiliation;
            }

            @Override
            public final AffiliationState getAffiliationState() {
                return this.affiliation;
            }
        }
    }

    public static final class Options
    extends PubSubChildElement {
        @XmlAttribute
        private final Jid jid;
        @XmlAttribute
        private final String subid;
        @XmlElementRef
        private final DataForm dataForm;

        private Options() {
            this(null, null, null, null);
        }

        private Options(String node, Jid jid, String subid, DataForm dataForm) {
            super(node);
            this.jid = jid;
            this.subid = subid;
            this.dataForm = dataForm;
        }

        private Options(DataForm dataForm) {
            this(null, null, null, dataForm);
        }

        public final DataForm getDataForm() {
            return this.dataForm;
        }
    }

    private static final class Subscribe
    extends PubSubChildElement {
        @XmlAttribute
        private final Jid jid;

        private Subscribe() {
            this((String)null, (Jid)null);
        }

        private Subscribe(String node, Jid jid) {
            super(node);
            this.jid = jid;
        }
    }

    private static final class Create
    extends PubSubChildElement {
        private Create() {
        }

        private Create(String node) {
            super(node);
        }
    }
}

