/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2016 Christian Schudt
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package rocks.xmpp.extensions.jingle.apps.model;

/**
 * An abstract base class for Jingle application formats. It is defined as:
 * <blockquote>
 * <p>The data format of the content type being established, which formally declares one purpose of the session (e.g.,
 * "audio" or "video"). This is the 'what' of the session (i.e., the bits to be transferred), such as the acceptable
 * codecs when establishing a voice conversation. In Jingle XML syntax the application format is the namespace of the
 * {@code <description/>} element.</p>
 * </blockquote>
 *
 * @author Christian Schudt
 * @see rocks.xmpp.extensions.jingle.model.Jingle.Content#getApplicationFormat()
 */
public abstract class ApplicationFormat {

    protected ApplicationFormat() {
    }
}
