/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.s5b.model;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.bytestreams.s5b.model.StreamHost;
import rocks.xmpp.extensions.bytestreams.s5b.model.StreamHostUsed;
import rocks.xmpp.util.XmppUtils;

@XmlRootElement(name="query")
public final class Socks5ByteStream {
    public static final String NAMESPACE = "http://jabber.org/protocol/bytestreams";
    private final List<StreamHost> streamhost = new ArrayList<StreamHost>();
    @XmlElement(name="streamhost-used")
    private StreamHostUsed streamHostUsed;
    @XmlAttribute
    private String dstaddr;
    private Jid activate;
    @XmlAttribute
    private Mode mode;
    @XmlAttribute
    private String sid;

    public Socks5ByteStream() {
    }

    public Socks5ByteStream(String sessionId, Collection<StreamHost> streamHosts, Jid requester, Jid target) {
        this.sid = Objects.requireNonNull(sessionId);
        this.streamhost.addAll(streamHosts);
        this.dstaddr = Socks5ByteStream.hash(sessionId, requester, target);
    }

    public static Socks5ByteStream activate(String sessionId, Jid jid) {
        Socks5ByteStream socks5ByteStream = new Socks5ByteStream();
        socks5ByteStream.sid = Objects.requireNonNull(sessionId);
        socks5ByteStream.activate = jid;
        return socks5ByteStream;
    }

    public static Socks5ByteStream streamHostUsed(String sessionId, Jid jid) {
        Socks5ByteStream socks5ByteStream = new Socks5ByteStream();
        socks5ByteStream.sid = Objects.requireNonNull(sessionId);
        socks5ByteStream.streamHostUsed = new StreamHostUsed(jid);
        return socks5ByteStream;
    }

    public static String hash(String sessionId, Jid requesterJid, Jid targetJid) {
        return XmppUtils.hash((byte[])(sessionId + requesterJid.toEscapedString() + targetJid.toEscapedString()).getBytes(StandardCharsets.UTF_8));
    }

    public final List<StreamHost> getStreamHosts() {
        return Collections.unmodifiableList(this.streamhost);
    }

    public final String getSessionId() {
        return this.sid;
    }

    public final Jid getStreamHostUsed() {
        return this.streamHostUsed != null ? this.streamHostUsed.jid : null;
    }

    public final String getDestinationAddress() {
        return this.dstaddr;
    }

    public final Mode getMode() {
        return this.mode;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.streamHostUsed != null) {
            sb.append(this.streamHostUsed);
        } else if (this.activate != null) {
            sb.append("Activate ").append((CharSequence)this.activate);
        } else {
            sb.append("Stream hosts: ").append(this.streamhost);
        }
        if (this.sid != null) {
            sb.append(" (").append(this.sid).append(')');
        }
        return sb.toString();
    }

    public static enum Mode {
        TCP,
        UDP;

    }
}

