/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privacy.model;

import java.text.Collator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.privacy.model.PrivacyRule;

public final class PrivacyList
implements Comparable<PrivacyList> {
    private static final Comparator<PrivacyList> COMPARATOR = Comparator.comparing(PrivacyList::isDefault, Comparator.reverseOrder()).thenComparing(PrivacyList::isActive, Comparator.reverseOrder()).thenComparing(PrivacyList::getName, Comparator.nullsLast((o1, o2) -> Collator.getInstance().compare((String)o1, (String)o2))).thenComparing(PrivacyList::getPrivacyRules, Comparator.nullsFirst((o1, o2) -> {
        int diff = o1.size() - o2.size();
        if (diff == 0) {
            if (Objects.equals(o1, o2)) {
                return 0;
            }
            for (PrivacyRule rule1 : o1) {
                for (PrivacyRule rule2 : o2) {
                    int result = Comparator.nullsFirst(PrivacyRule::compareTo).compare(rule1, rule2);
                    if (result == 0) continue;
                    return result;
                }
            }
        }
        return diff;
    }));
    private final List<PrivacyRule> item = new ArrayList<PrivacyRule>();
    @XmlAttribute
    private final String name;
    @XmlTransient
    private boolean isActive;
    @XmlTransient
    private boolean isDefault;

    private PrivacyList() {
        this.name = null;
    }

    public PrivacyList(String name, Collection<PrivacyRule> items) {
        this.name = Objects.requireNonNull(name);
        if (items != null) {
            this.item.addAll(items);
        }
    }

    public PrivacyList(String name) {
        this.name = name;
    }

    public static PrivacyList createInvisibilityList() {
        return PrivacyList.createInvisibilityListExceptForUsers("invisible", new Jid[0]);
    }

    public static PrivacyList createInvisibilityListExceptForUsers(String listName, Jid ... jids) {
        ArrayDeque<PrivacyRule> rules = new ArrayDeque<PrivacyRule>();
        long order = 1L;
        for (Jid jid : jids) {
            rules.add(PrivacyRule.of(jid, PrivacyRule.Action.ALLOW, order++).appliedToOutboundPresence());
        }
        rules.add(PrivacyRule.blockOutboundPresence(order));
        return new PrivacyList(listName, rules);
    }

    public static PrivacyList createInvisibilityListExceptForGroups(String listName, String ... groups) {
        ArrayDeque<PrivacyRule> rules = new ArrayDeque<PrivacyRule>();
        long order = 1L;
        for (String group : groups) {
            rules.add(PrivacyRule.of(group, PrivacyRule.Action.ALLOW, order++).appliedToOutboundPresence());
        }
        rules.add(PrivacyRule.blockOutboundPresence(order));
        return new PrivacyList(listName, rules);
    }

    public static PrivacyList createInvisibilityListForUsers(String listName, Jid ... jids) {
        ArrayDeque<PrivacyRule> rules = new ArrayDeque<PrivacyRule>();
        long order = 1L;
        for (Jid jid : jids) {
            rules.add(PrivacyRule.blockPresenceTo(jid, order++));
        }
        rules.add(PrivacyRule.of(PrivacyRule.Action.ALLOW, order).appliedToOutboundPresence());
        return new PrivacyList(listName, rules);
    }

    public static PrivacyList createInvisibilityListForGroups(String listName, String ... groups) {
        ArrayDeque<PrivacyRule> rules = new ArrayDeque<PrivacyRule>();
        long order = 1L;
        for (String group : groups) {
            rules.add(PrivacyRule.blockPresenceToRosterGroup(group, order++));
        }
        rules.add(PrivacyRule.of(PrivacyRule.Action.ALLOW, order).appliedToOutboundPresence());
        return new PrivacyList(listName, rules);
    }

    public final List<PrivacyRule> getPrivacyRules() {
        return Collections.unmodifiableList(this.item);
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDefault() {
        return this.isDefault;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final PrivacyList asActive() {
        PrivacyList privacyList = new PrivacyList(this.name, this.item);
        privacyList.isActive = true;
        return privacyList;
    }

    public final PrivacyList asDefault() {
        PrivacyList privacyList = new PrivacyList(this.name, this.item);
        privacyList.isDefault = true;
        return privacyList;
    }

    @Override
    public final int compareTo(PrivacyList o) {
        return COMPARATOR.compare(this, o);
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrivacyList)) {
            return false;
        }
        PrivacyList other = (PrivacyList)o;
        return Objects.equals(this.item, other.item) && Objects.equals(this.name, other.name) && this.isDefault == other.isDefault && this.isActive == other.isActive;
    }

    public final int hashCode() {
        return Objects.hash(this.item, this.name, this.isDefault, this.isActive);
    }

    public final String toString() {
        return this.name;
    }
}

