/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model.owner;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.pubsub.model.Affiliation;
import rocks.xmpp.extensions.pubsub.model.AffiliationState;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.SubscriptionState;
import rocks.xmpp.util.adapters.InstantAdapter;

@XmlRootElement(name="pubsub")
public final class PubSubOwner {
    @XmlElements(value={@XmlElement(name="affiliations", type=Affiliations.class), @XmlElement(name="configure", type=Configure.class), @XmlElement(name="default", type=Default.class), @XmlElement(name="delete", type=Delete.class), @XmlElement(name="purge", type=Purge.class), @XmlElement(name="subscriptions", type=Subscriptions.class)})
    private final PubSubOwnerChildElement type;

    private PubSubOwner() {
        this.type = null;
    }

    private PubSubOwner(PubSubOwnerChildElement type) {
        this.type = type;
    }

    public static PubSubOwner withConfigure(String node) {
        return new PubSubOwner(new Configure(node));
    }

    public static PubSubOwner withConfigure(String node, DataForm dataForm) {
        return new PubSubOwner(new Configure(node, dataForm));
    }

    public static PubSubOwner withDefault() {
        return new PubSubOwner(new Default());
    }

    public static PubSubOwner withDelete(String node) {
        return new PubSubOwner(new Delete(node));
    }

    public static PubSubOwner withDelete(String node, URI replacementNode) {
        return new PubSubOwner(new Delete(node, new Delete.Redirect(replacementNode)));
    }

    public static PubSubOwner withPurge(String node) {
        return new PubSubOwner(new Purge(node));
    }

    public static PubSubOwner withSubscriptions(String node, Subscription ... subscriptions) {
        return new PubSubOwner(new Subscriptions(node, subscriptions));
    }

    public static PubSubOwner withAffiliations(String node, Affiliation ... affiliationNodes) {
        return new PubSubOwner(new Affiliations(node, affiliationNodes));
    }

    public final DataForm getConfigurationForm() {
        if (this.type instanceof Configure) {
            return ((Configure)this.type).getDataForm();
        }
        if (this.type instanceof Default) {
            return ((Default)this.type).dataForm;
        }
        return null;
    }

    public final String getNode() {
        return this.type != null ? this.type.node : null;
    }

    public final boolean isConfigure() {
        return this.type instanceof Configure;
    }

    public final boolean isDefault() {
        return this.type instanceof Default;
    }

    public final boolean isDelete() {
        return this.type instanceof Delete;
    }

    public final boolean isPurge() {
        return this.type instanceof Purge;
    }

    public final boolean isSubscriptions() {
        return this.type instanceof Subscriptions;
    }

    public final boolean isAffiliations() {
        return this.type instanceof Affiliations;
    }

    public final List<Subscription> getSubscriptions() {
        if (this.type instanceof Subscriptions) {
            return Collections.unmodifiableList(new ArrayList<Subscriptions.SubscriptionOwner>(((Subscriptions)this.type).subscription));
        }
        return Collections.emptyList();
    }

    public final List<Affiliation> getAffiliations() {
        if (this.type instanceof Affiliations) {
            return Collections.unmodifiableList(new ArrayList<Affiliations.AffiliationNodeOwner>(((Affiliations)this.type).affiliation));
        }
        return Collections.emptyList();
    }

    public final URI getRedirectUri() {
        if (this.type instanceof Delete && ((Delete)this.type).getRedirect() != null) {
            return ((Delete)this.type).getRedirect().uri;
        }
        return null;
    }

    @XmlTransient
    private static abstract class PubSubOwnerChildElement {
        @XmlAttribute
        private final String node;

        private PubSubOwnerChildElement() {
            this(null);
        }

        private PubSubOwnerChildElement(String node) {
            this.node = node;
        }

        public final String getNode() {
            return this.node;
        }
    }

    private static final class Subscriptions
    extends PubSubOwnerChildElement {
        private final List<SubscriptionOwner> subscription = new ArrayList<SubscriptionOwner>();

        private Subscriptions() {
        }

        private Subscriptions(String node, Subscription ... subscriptions) {
            super(node);
            for (Subscription subscription : subscriptions) {
                this.subscription.add(new SubscriptionOwner(subscription.getNode(), subscription.getJid(), subscription.getSubId(), subscription.getSubscriptionState(), subscription.getExpiry(), subscription.isConfigurationSupported() ? new SubscriptionOwner.Options(subscription.isConfigurationRequired()) : null));
            }
        }

        private static final class SubscriptionOwner
        extends PubSubOwnerChildElement
        implements Subscription {
            @XmlAttribute
            private final Jid jid;
            @XmlAttribute
            private final String subid;
            @XmlAttribute
            private final SubscriptionState subscription;
            @XmlAttribute
            @XmlJavaTypeAdapter(value=InstantAdapter.class)
            private final Instant expiry;
            @XmlElement(name="subscribe-options")
            private final Options options;

            private SubscriptionOwner() {
                this(null, null, null, null, null, null);
            }

            private SubscriptionOwner(String node, Jid jid, String subid, SubscriptionState subscription, Instant expiry, Options options) {
                super(node);
                this.jid = jid;
                this.subid = subid;
                this.subscription = subscription;
                this.expiry = expiry;
                this.options = options;
            }

            @Override
            public final SubscriptionState getSubscriptionState() {
                return this.subscription;
            }

            @Override
            public final Jid getJid() {
                return this.jid;
            }

            @Override
            public final String getSubId() {
                return this.subid;
            }

            @Override
            public final Instant getExpiry() {
                return this.expiry;
            }

            @Override
            public final boolean isConfigurationRequired() {
                return this.options != null && this.options.isRequired();
            }

            @Override
            public final boolean isConfigurationSupported() {
                return this.options != null;
            }

            private static final class Options {
                private final String required;

                private Options() {
                    this.required = null;
                }

                private Options(boolean required) {
                    this.required = required ? "" : null;
                }

                private boolean isRequired() {
                    return this.required != null;
                }
            }
        }
    }

    private static final class Purge
    extends PubSubOwnerChildElement {
        private Purge() {
        }

        private Purge(String node) {
            super(node);
        }
    }

    private static final class Delete
    extends PubSubOwnerChildElement {
        private final Redirect redirect;

        private Delete() {
            this(null);
        }

        private Delete(String node) {
            this(node, null);
        }

        private Delete(String node, Redirect redirect) {
            super(node);
            this.redirect = redirect;
        }

        private Redirect getRedirect() {
            return this.redirect;
        }

        private static final class Redirect {
            @XmlAttribute
            private final URI uri;

            private Redirect() {
                this(null);
            }

            private Redirect(URI uri) {
                this.uri = uri;
            }
        }
    }

    private static final class Default
    extends PubSubOwnerChildElement {
        @XmlElementRef
        private final DataForm dataForm = null;

        private Default() {
        }
    }

    private static final class Configure
    extends PubSubOwnerChildElement {
        @XmlElementRef
        private final DataForm dataForm;

        private Configure() {
            this(null);
        }

        private Configure(String node) {
            this(node, null);
        }

        private Configure(String node, DataForm dataForm) {
            super(node);
            this.dataForm = dataForm;
        }

        private DataForm getDataForm() {
            return this.dataForm;
        }
    }

    private static final class Affiliations
    extends PubSubOwnerChildElement {
        private final List<AffiliationNodeOwner> affiliation = new ArrayList<AffiliationNodeOwner>();

        private Affiliations() {
            this(null, new Affiliation[0]);
        }

        private Affiliations(String node, Affiliation ... affiliations) {
            super(node);
            for (Affiliation affiliation : affiliations) {
                this.affiliation.add(new AffiliationNodeOwner(affiliation.getNode(), affiliation.getAffiliationState(), affiliation.getJid()));
            }
        }

        private static final class AffiliationNodeOwner
        implements Affiliation {
            @XmlAttribute
            private final String node;
            @XmlAttribute
            private final AffiliationState affiliation;
            @XmlAttribute
            private final Jid jid;

            private AffiliationNodeOwner() {
                this(null, null, null);
            }

            private AffiliationNodeOwner(String node, AffiliationState affiliation, Jid jid) {
                this.node = node;
                this.affiliation = affiliation;
                this.jid = jid;
            }

            public final Jid getJid() {
                return this.jid;
            }

            @Override
            public final AffiliationState getAffiliationState() {
                return this.affiliation;
            }

            @Override
            public final String getNode() {
                return this.node;
            }
        }
    }
}

