/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.shim;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.shim.HeaderManager;
import rocks.xmpp.util.concurrent.AsyncResult;

public class StanzaHeadersAndInternetMetadataProtocol
implements HeaderManager,
DiscoverableInfo {
    private static final Set<String> FEATURES = Collections.singleton("http://jabber.org/protocol/shim");
    private final Set<String> supportedHeaders = new CopyOnWriteArraySet<String>();
    private final DiscoverableInfo discoverableInfo = new HeaderInfo();
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    public StanzaHeadersAndInternetMetadataProtocol(ServiceDiscoveryManager serviceDiscoveryManager) {
        this.serviceDiscoveryManager = serviceDiscoveryManager;
    }

    @Override
    public final Set<String> getSupportedHeaders() {
        return Collections.unmodifiableSet(this.supportedHeaders);
    }

    @Override
    public boolean addSupportedHeader(String header) {
        return this.supportedHeaders.add(header);
    }

    @Override
    public boolean removeSupportedHeader(String header) {
        return this.supportedHeaders.remove(header);
    }

    @Override
    public final AsyncResult<List<String>> discoverSupportedHeaders(Jid jid) {
        return this.serviceDiscoveryManager.discoverInformation(jid, "http://jabber.org/protocol/shim").thenApply(infoNode -> infoNode.getFeatures().stream().map(feature -> feature.substring(feature.indexOf(35) + 1)).collect(Collectors.toList()));
    }

    public final String getNamespace() {
        return "http://jabber.org/protocol/shim";
    }

    public final boolean isEnabled() {
        return !this.supportedHeaders.isEmpty();
    }

    public final Set<String> getFeatures() {
        return FEATURES;
    }

    public final DiscoverableInfo getInfo(Jid to, Jid from, String node, Locale locale) {
        if (this.isEnabled() && "http://jabber.org/protocol/shim".equals(node)) {
            return this.discoverableInfo;
        }
        return null;
    }

    private final class HeaderInfo
    implements DiscoverableInfo {
        private HeaderInfo() {
        }

        public final Set<Identity> getIdentities() {
            return Collections.emptySet();
        }

        public final Set<String> getFeatures() {
            return StanzaHeadersAndInternetMetadataProtocol.this.supportedHeaders.stream().map(supportedHeader -> "http://jabber.org/protocol/shim#" + supportedHeader).collect(Collectors.toSet());
        }

        public final List<DataForm> getExtensions() {
            return Collections.emptyList();
        }
    }
}

