/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.shim.model;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;

public final class Header {
    @XmlAttribute
    private final String name;
    @XmlValue
    private final String value;

    private Header() {
        this(null, null);
    }

    private Header(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static Header of(String name, String value) {
        return new Header(Objects.requireNonNull(name), value);
    }

    public static Header ofClassification(String value) {
        return Header.of("Classification", value);
    }

    public static Header ofCreated(OffsetDateTime dateTime) {
        return Header.of("Created", dateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
    }

    public static Header ofDistribute(boolean distribute) {
        return Header.of("Distribute", Boolean.toString(distribute));
    }

    public static Header ofStore(boolean store) {
        return Header.of("Store", Boolean.toString(store));
    }

    public static Header ofTimeToLive(Duration timeToLive) {
        return Header.of("TTL", String.valueOf(timeToLive.getSeconds()));
    }

    public static Header ofUrgency(String urgency) {
        if (!(urgency.equals("high") || urgency.equals("medium") || urgency.equals("low"))) {
            throw new IllegalArgumentException("urgency must be 'high', 'medium' or 'value', but is '" + urgency + "'");
        }
        return Header.of("Urgency", urgency);
    }

    public static Header ofStartDate(OffsetDateTime dateTime) {
        return Header.of("Start", dateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
    }

    public static Header ofStopDate(OffsetDateTime dateTime) {
        return Header.of("Stop", dateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
    }

    public final String getName() {
        return this.name;
    }

    public final String getValue() {
        return this.value;
    }

    public final String toString() {
        return this.name + ": " + this.value;
    }
}

