/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.si.profile.filetransfer.model;

import java.math.BigInteger;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.extensions.filetransfer.model.FileTransferOffer;
import rocks.xmpp.extensions.filetransfer.model.Range;
import rocks.xmpp.extensions.hashes.model.Hash;
import rocks.xmpp.util.adapters.InstantAdapter;

@XmlRootElement(name="file")
public final class SIFileTransferOffer
implements FileTransferOffer {
    public static final String NAMESPACE = "http://jabber.org/protocol/si/profile/file-transfer";
    @XmlAttribute
    private final Long size;
    @XmlAttribute
    private final String name;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=InstantAdapter.class)
    private final Instant date;
    @XmlAttribute
    private final String hash;
    private final String desc;
    private final SIRange range;

    private SIFileTransferOffer() {
        this(null, 0L);
    }

    public SIFileTransferOffer(String name, long size) {
        this(name, size, null, null, null, null);
    }

    public SIFileTransferOffer(String name, long size, Instant lastModified, String hash, String description, SIRange range) {
        this.name = name;
        this.size = size;
        this.date = lastModified;
        this.hash = hash;
        this.desc = description;
        this.range = range;
    }

    @Override
    public final long getSize() {
        return this.size != null ? this.size : 0L;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Instant getDate() {
        return this.date;
    }

    @Override
    public final List<Hash> getHashes() {
        if (this.hash != null) {
            return Collections.unmodifiableList(Collections.singletonList(new Hash(new BigInteger(this.hash, 16).toByteArray(), "md5")));
        }
        return Collections.emptyList();
    }

    @Override
    public final String getDescription() {
        return this.desc;
    }

    @Override
    public final Range getRange() {
        return this.range;
    }

    public static final class SIRange
    implements Range {
        @XmlAttribute
        private final long offset;
        @XmlAttribute
        private final long length;

        private SIRange() {
            this.length = 0L;
            this.offset = 0L;
        }

        public SIRange(long offset, long length) {
            this.offset = offset;
            this.length = length;
        }

        @Override
        public final long getOffset() {
            return this.offset;
        }

        @Override
        public final long getLength() {
            return this.length;
        }
    }
}

