/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc.model;

import java.time.Instant;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.util.adapters.InstantAdapter;

public final class DiscussionHistory {
    @XmlAttribute(name="maxchars")
    private final Integer maxChars;
    @XmlAttribute
    private final Integer maxstanzas;
    @XmlAttribute
    private final Integer seconds;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=InstantAdapter.class)
    private final Instant since;

    private DiscussionHistory() {
        this(null, null, null, null);
    }

    private DiscussionHistory(Integer maxChars, Integer maxstanzas, Integer seconds, Instant since) {
        this.maxChars = maxChars;
        this.maxstanzas = maxstanzas;
        this.seconds = seconds;
        this.since = since;
    }

    public static DiscussionHistory forMaxChars(int maxChars) {
        return new DiscussionHistory(maxChars, null, null, null);
    }

    public static DiscussionHistory forMaxMessages(int maxMessages) {
        return new DiscussionHistory(null, maxMessages, null, null);
    }

    public static DiscussionHistory forSeconds(int seconds) {
        return new DiscussionHistory(null, null, seconds, null);
    }

    public static DiscussionHistory since(Instant date) {
        return new DiscussionHistory(null, null, null, date);
    }

    public static DiscussionHistory none() {
        return new DiscussionHistory(0, null, null, null);
    }

    public final String toString() {
        if (this.maxChars != null && this.maxChars == 0) {
            return "No discussion history";
        }
        StringBuilder sb = new StringBuilder("Discussion history ");
        boolean appended = false;
        if (this.maxChars != null) {
            sb.append("limited to ").append(this.maxChars).append(" characters");
            appended = true;
        }
        if (this.maxstanzas != null) {
            if (appended) {
                sb.append(", ");
            }
            sb.append("limited to ").append(this.maxstanzas).append(" messages");
            appended = true;
        }
        if (this.seconds != null) {
            if (appended) {
                sb.append(", ");
            }
            sb.append("for the last ").append(this.seconds).append(" seconds");
            appended = true;
        }
        if (this.since != null) {
            if (appended) {
                sb.append(", ");
            }
            sb.append("since ").append(this.since);
        }
        return sb.toString();
    }
}

