/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import rocks.xmpp.extensions.data.StandardizedDataForm;
import rocks.xmpp.extensions.data.model.DataForm;

public final class RoomRegistration
implements StandardizedDataForm {
    private static final String FORM_TYPE = "http://jabber.org/protocol/muc#register";
    private static final String REGISTER_ALLOW = "muc#register_allow";
    private static final String EMAIL = "muc#register_email";
    private static final String FAQ_ENTRY = "muc#register_faqentry";
    private static final String GIVEN_NAME = "muc#register_first";
    private static final String FAMILY_NAME = "muc#register_last";
    private static final String ROOM_NICK = "muc#register_roomnick";
    private static final String URL = "muc#register_url";
    private final DataForm dataForm;

    public RoomRegistration(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEmail() {
        return this.dataForm.findValue(EMAIL);
    }

    public String getFamilyName() {
        return this.dataForm.findValue(FAMILY_NAME);
    }

    public String getGivenName() {
        return this.dataForm.findValue(GIVEN_NAME);
    }

    public String getRoomNick() {
        return this.dataForm.findValue(ROOM_NICK);
    }

    public URL getWebPage() {
        String value = this.dataForm.findValue(URL);
        if (value != null) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public String getFaqEntry() {
        return this.dataForm.findValue(FAQ_ENTRY);
    }

    public boolean isRegisterAllowed() {
        return this.dataForm.findValueAsBoolean(REGISTER_ALLOW);
    }

    public final String getFormType() {
        return FORM_TYPE;
    }

    public final DataForm getDataForm() {
        return this.dataForm;
    }

    public final Builder toBuilder() {
        return RoomRegistration.builder().allowRegister(this.isRegisterAllowed()).email(this.getEmail()).familyName(this.getFamilyName()).faqEntry(this.getFaqEntry()).givenName(this.getGivenName()).nickname(this.getRoomNick()).webPage(this.getWebPage());
    }

    public static final class Builder
    extends DataForm.Builder<Builder> {
        private Boolean allowRegister;
        private String email;
        private String faqEntry;
        private String givenName;
        private String familyName;
        private String nickname;
        private URL webPage;

        private Builder() {
        }

        public Builder allowRegister(boolean allowRegister) {
            this.allowRegister = allowRegister;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder faqEntry(String faqEntry) {
            this.faqEntry = faqEntry;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder nickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public Builder webPage(URL webPage) {
            this.webPage = webPage;
            return this;
        }

        protected Builder self() {
            return this;
        }

        public RoomRegistration build() {
            ArrayDeque<DataForm.Field> fields = new ArrayDeque<DataForm.Field>();
            if (this.allowRegister != null) {
                fields.add(DataForm.Field.builder().name(RoomRegistration.REGISTER_ALLOW).value(this.allowRegister.booleanValue()).build());
            }
            if (this.email != null) {
                fields.add(DataForm.Field.builder().name(RoomRegistration.EMAIL).value(this.email).build());
            }
            if (this.faqEntry != null) {
                fields.add(DataForm.Field.builder().name(RoomRegistration.FAQ_ENTRY).value(this.faqEntry).type(DataForm.Field.Type.TEXT_MULTI).build());
            }
            if (this.givenName != null) {
                fields.add(DataForm.Field.builder().name(RoomRegistration.GIVEN_NAME).value(this.givenName).build());
            }
            if (this.familyName != null) {
                fields.add(DataForm.Field.builder().name(RoomRegistration.FAMILY_NAME).value(this.familyName).build());
            }
            if (this.nickname != null) {
                fields.add(DataForm.Field.builder().name(RoomRegistration.ROOM_NICK).value(this.nickname).build());
            }
            if (this.webPage != null) {
                fields.add(DataForm.Field.builder().name(RoomRegistration.URL).value(this.webPage.toString()).build());
            }
            ((Builder)((Builder)this.fields(fields)).formType(RoomRegistration.FORM_TYPE)).type(DataForm.Type.SUBMIT);
            return new RoomRegistration(new DataForm((DataForm.Builder)this));
        }
    }
}

