/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.extensions.data.StandardizedDataForm;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.pubsub.model.AccessModel;
import rocks.xmpp.extensions.pubsub.model.ChildrenAssociationPolicy;
import rocks.xmpp.extensions.pubsub.model.ItemReply;
import rocks.xmpp.extensions.pubsub.model.NodeType;
import rocks.xmpp.extensions.pubsub.model.PublisherModel;
import rocks.xmpp.extensions.pubsub.model.SendLastPublishedItem;

public final class NodeConfiguration
implements StandardizedDataForm {
    private static final String FORM_TYPE = "http://jabber.org/protocol/pubsub#node_config";
    private static final String ACCESS_MODEL = "pubsub#access_model";
    private static final String BODY_XSLT = "pubsub#body_xslt";
    private static final String CHILDREN_ASSOCIATION_POLICY = "pubsub#children_association_policy";
    private static final String CHILDREN_ASSOCIATION_WHITELIST = "pubsub#children_association_whitelist";
    private static final String CHILDREN = "pubsub#children";
    private static final String CHILDREN_MAX = "pubsub#children_max";
    private static final String COLLECTION = "pubsub#collection";
    private static final String CONTACT = "pubsub#contact";
    private static final String DATAFORM_XSLT = "pubsub#dataform_xslt";
    private static final String DELIVER_NOTIFICATIONS = "pubsub#deliver_notifications";
    private static final String DELIVER_PAYLOADS = "pubsub#deliver_payloads";
    private static final String DESCRIPTION = "pubsub#description";
    private static final String ITEM_EXPIRE = "pubsub#item_expire";
    private static final String ITEM_REPLY = "pubsub#itemreply";
    private static final String LANGUAGE = "pubsub#language";
    private static final String MAX_ITEMS = "pubsub#max_items";
    private static final String MAX_PAYLOAD_SIZE = "pubsub#max_payload_size";
    private static final String NODE_TYPE = "pubsub#node_type";
    private static final String NOTIFICATION_TYPE = "pubsub#notification_type";
    private static final String NOTIFY_CONFIG = "pubsub#notify_config";
    private static final String NOTIFY_DELETE = "pubsub#notify_delete";
    private static final String NOTIFY_RETRACT = "pubsub#notify_retract";
    private static final String NOTIFY_SUB = "pubsub#notify_sub";
    private static final String PERSIST_ITEMS = "pubsub#persist_items";
    private static final String PRESENCE_BASED_DELIVERY = "pubsub#presence_based_delivery";
    private static final String PUBLISH_MODEL = "pubsub#publish_model";
    private static final String PURGE_OFFLINE = "pubsub#purge_offline";
    private static final String ROSTER_GROUPS_ALLOWED = "pubsub#roster_groups_allowed";
    private static final String SEND_LAST_PUBLISHED_ITEM = "pubsub#send_last_published_item";
    private static final String TEMPSUB = "pubsub#tempsub";
    private static final String SUBSCRIBE = "pubsub#subscribe";
    private static final String TITLE = "pubsub#title";
    private static final String TYPE = "pubsub#type";
    private final DataForm dataForm;

    public NodeConfiguration(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final String getFormType() {
        return FORM_TYPE;
    }

    public final DataForm getDataForm() {
        return this.dataForm;
    }

    public final AccessModel getAccessModel() {
        String value = this.dataForm.findValue(ACCESS_MODEL);
        if (value != null) {
            return AccessModel.valueOf(value.toUpperCase());
        }
        return null;
    }

    public final URL getBodyXslt() {
        String value = this.dataForm.findValue(BODY_XSLT);
        try {
            return value != null ? new URL(value) : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public final ChildrenAssociationPolicy getChildrenAssociationPolicy() {
        String value = this.dataForm.findValue(CHILDREN_ASSOCIATION_POLICY);
        if (value != null) {
            return ChildrenAssociationPolicy.valueOf(value.toUpperCase());
        }
        return null;
    }

    public final List<Jid> getChildrenAssociationWhitelist() {
        return this.dataForm.findValuesAsJid(CHILDREN_ASSOCIATION_WHITELIST);
    }

    public final List<String> getChildren() {
        return this.dataForm.findValues(CHILDREN);
    }

    public final Integer getChildrenMax() {
        return this.dataForm.findValueAsInteger(CHILDREN_MAX);
    }

    public final List<String> getCollection() {
        return this.dataForm.findValues(COLLECTION);
    }

    public final List<Jid> getContacts() {
        return this.dataForm.findValuesAsJid(CONTACT);
    }

    public final URL getDataformXslt() {
        String value = this.dataForm.findValue(DATAFORM_XSLT);
        try {
            return value != null ? new URL(value) : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public final Boolean isDeliverNotifications() {
        return this.dataForm.findValueAsBoolean(DELIVER_NOTIFICATIONS);
    }

    public final Boolean isDeliverPayloads() {
        return this.dataForm.findValueAsBoolean(DELIVER_PAYLOADS);
    }

    public final String getDescription() {
        return this.dataForm.findValue(DESCRIPTION);
    }

    public final Integer getItemExpire() {
        return this.dataForm.findValueAsInteger(ITEM_EXPIRE);
    }

    public final ItemReply getItemReply() {
        String value = this.dataForm.findValue(ITEM_REPLY);
        if (value != null) {
            return ItemReply.valueOf(value.toUpperCase());
        }
        return null;
    }

    public final String getLanguage() {
        return this.dataForm.findValue(LANGUAGE);
    }

    public final Integer getMaxItems() {
        return this.dataForm.findValueAsInteger(MAX_ITEMS);
    }

    public final Integer getMaxPayloadSize() {
        return this.dataForm.findValueAsInteger(MAX_PAYLOAD_SIZE);
    }

    public final NodeType getNodeType() {
        String value = this.dataForm.findValue(NODE_TYPE);
        if (value != null) {
            return NodeType.valueOf(value.toUpperCase());
        }
        return null;
    }

    public final Message.Type getNotificationType() {
        String value = this.dataForm.findValue(NOTIFICATION_TYPE);
        if (value != null) {
            return Message.Type.valueOf((String)value.toUpperCase());
        }
        return null;
    }

    public final Boolean isNotifyConfig() {
        return this.dataForm.findValueAsBoolean(NOTIFY_CONFIG);
    }

    public final Boolean isNotifyDelete() {
        return this.dataForm.findValueAsBoolean(NOTIFY_DELETE);
    }

    public final Boolean isNotifyRetract() {
        return this.dataForm.findValueAsBoolean(NOTIFY_RETRACT);
    }

    public final Boolean isNotifySub() {
        return this.dataForm.findValueAsBoolean(NOTIFY_SUB);
    }

    public final Boolean isPersistItems() {
        return this.dataForm.findValueAsBoolean(PERSIST_ITEMS);
    }

    public final Boolean isPresenceBasedDelivery() {
        return this.dataForm.findValueAsBoolean(PRESENCE_BASED_DELIVERY);
    }

    public final PublisherModel getPublisherModel() {
        String value = this.dataForm.findValue(PUBLISH_MODEL);
        if (value != null) {
            return PublisherModel.valueOf(value.toUpperCase());
        }
        return null;
    }

    public final Boolean isPurgeOffline() {
        return this.dataForm.findValueAsBoolean(PURGE_OFFLINE);
    }

    public final List<String> getRosterGroupsAllowed() {
        return this.dataForm.findValues(ROSTER_GROUPS_ALLOWED);
    }

    public final SendLastPublishedItem getSendLastPublishedItem() {
        String value = this.dataForm.findValue(SEND_LAST_PUBLISHED_ITEM);
        if (value != null) {
            return SendLastPublishedItem.valueOf(value.toUpperCase());
        }
        return null;
    }

    public final Boolean isTemporarySubscriptions() {
        return this.dataForm.findValueAsBoolean(TEMPSUB);
    }

    public final Boolean isAllowSubscriptions() {
        return this.dataForm.findValueAsBoolean(SUBSCRIBE);
    }

    public final String getNodeTitle() {
        return this.dataForm.findValue(TITLE);
    }

    public final String getPayloadType() {
        return this.dataForm.findValue(TYPE);
    }

    public final Builder toBuilder() {
        return NodeConfiguration.builder().accessModel(this.getAccessModel()).allowSubscriptions(this.isAllowSubscriptions()).bodyXslt(this.getBodyXslt()).childrenAssociationPolicy(this.getChildrenAssociationPolicy()).childrenAssociationWhitelist(this.getChildrenAssociationWhitelist()).children(this.getChildren()).childrenMax(this.getChildrenMax()).collection(this.getCollection()).contacts(this.getContacts()).dataformXslt(this.getDataformXslt()).deliverNotifications(this.isDeliverNotifications()).deliverPayloads(this.isDeliverPayloads()).description(this.getDescription()).itemExpire(this.getItemExpire()).itemReply(this.getItemReply()).language(this.getLanguage()).maxItems(this.getMaxItems()).maxPayloadSize(this.getMaxPayloadSize()).nodeType(this.getNodeType()).notificationType(this.getNotificationType()).notifyConfig(this.isNotifyConfig()).notifyDelete(this.isNotifyDelete()).notifyRetract(this.isNotifyRetract()).notifySub(this.isNotifySub()).persistItems(this.isPersistItems()).presenceBasedDelivery(this.isPresenceBasedDelivery()).publisherModel(this.getPublisherModel()).purgeOffline(this.isPurgeOffline()).rosterGroupsAllowed(this.getRosterGroupsAllowed()).sendLastPublishedItem(this.getSendLastPublishedItem()).temporarySubscriptions(this.isTemporarySubscriptions()).nodeTitle(this.getNodeTitle()).type(this.getPayloadType());
    }

    public static final class Builder
    extends DataForm.Builder<Builder> {
        private AccessModel accessModel;
        private Boolean allowSubscriptions;
        private URL bodyXslt;
        private ChildrenAssociationPolicy childrenAssociationPolicy;
        private Collection<Jid> childrenAssociationWhitelist;
        private Collection<String> children;
        private Integer childrenMax;
        private Collection<String> collection;
        private Collection<Jid> contacts;
        private URL dataformXslt;
        private Boolean deliverNotifications;
        private Boolean deliverPayloads;
        private String description;
        private Integer itemExpire;
        private ItemReply itemReply;
        private String language;
        private Integer maxItems;
        private Integer maxPayloadSize;
        private NodeType nodeType;
        private Message.Type notificationType;
        private Boolean notifyConfig;
        private Boolean notifyDelete;
        private Boolean notifyRetract;
        private Boolean notifySub;
        private Boolean persistItems;
        private Boolean presenceBasedDelivery;
        private PublisherModel publisherModel;
        private Boolean purgeOffline;
        private Collection<String> rosterGroupsAllowed;
        private SendLastPublishedItem sendLastPublishedItem;
        private Boolean temporarySubscriptions;
        private String nodeTitle;
        private String type;

        private Builder() {
        }

        public final Builder accessModel(AccessModel accessModel) {
            this.accessModel = accessModel;
            return this;
        }

        public final Builder allowSubscriptions(Boolean allowSubscriptions) {
            this.allowSubscriptions = allowSubscriptions;
            return this;
        }

        public final Builder bodyXslt(URL bodyXslt) {
            this.bodyXslt = bodyXslt;
            return this;
        }

        public final Builder childrenAssociationPolicy(ChildrenAssociationPolicy childrenAssociationPolicy) {
            this.childrenAssociationPolicy = childrenAssociationPolicy;
            return this;
        }

        public final Builder childrenAssociationWhitelist(Collection<Jid> childrenAssociationWhitelist) {
            this.childrenAssociationWhitelist = childrenAssociationWhitelist;
            return this;
        }

        public final Builder children(Collection<String> children) {
            this.children = children;
            return this;
        }

        public final Builder childrenMax(Integer childrenMax) {
            this.childrenMax = childrenMax;
            return this;
        }

        public final Builder collection(Collection<String> collection) {
            this.collection = collection;
            return this;
        }

        public final Builder contacts(Collection<Jid> contacts) {
            this.contacts = contacts;
            return this;
        }

        public final Builder dataformXslt(URL dataformXslt) {
            this.dataformXslt = dataformXslt;
            return this;
        }

        public final Builder deliverNotifications(Boolean deliverNotifications) {
            this.deliverNotifications = deliverNotifications;
            return this;
        }

        public final Builder deliverPayloads(Boolean deliverPayloads) {
            this.deliverPayloads = deliverPayloads;
            return this;
        }

        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Builder itemExpire(Integer itemExpire) {
            this.itemExpire = itemExpire;
            return this;
        }

        public final Builder itemReply(ItemReply itemReply) {
            this.itemReply = itemReply;
            return this;
        }

        public final Builder language(Locale language) {
            this.language = language != null ? language.toLanguageTag() : null;
            return this;
        }

        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final Builder maxPayloadSize(Integer maxPayloadSize) {
            this.maxPayloadSize = maxPayloadSize;
            return this;
        }

        public final Builder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Builder notificationType(Message.Type notificationType) {
            if (notificationType != null && notificationType != Message.Type.HEADLINE && notificationType != Message.Type.NORMAL) {
                throw new IllegalArgumentException("only 'normal' and 'headline' type allowed.");
            }
            this.notificationType = notificationType;
            return this;
        }

        public final Builder notifyConfig(Boolean notifyConfig) {
            this.notifyConfig = notifyConfig;
            return this;
        }

        public final Builder notifyDelete(Boolean notifyDelete) {
            this.notifyDelete = notifyDelete;
            return this;
        }

        public final Builder notifyRetract(Boolean notifyRetract) {
            this.notifyRetract = notifyRetract;
            return this;
        }

        public final Builder notifySub(Boolean notifySub) {
            this.notifySub = notifySub;
            return this;
        }

        public final Builder persistItems(Boolean persistItems) {
            this.persistItems = persistItems;
            return this;
        }

        public final Builder presenceBasedDelivery(Boolean presenceBasedDelivery) {
            this.presenceBasedDelivery = presenceBasedDelivery;
            return this;
        }

        public final Builder publisherModel(PublisherModel publisherModel) {
            this.publisherModel = publisherModel;
            return this;
        }

        public final Builder purgeOffline(Boolean purgeOffline) {
            this.purgeOffline = purgeOffline;
            return this;
        }

        public final Builder rosterGroupsAllowed(Collection<String> rosterGroupsAllowed) {
            this.rosterGroupsAllowed = rosterGroupsAllowed;
            return this;
        }

        public final Builder sendLastPublishedItem(SendLastPublishedItem sendLastPublishedItem) {
            this.sendLastPublishedItem = sendLastPublishedItem;
            return this;
        }

        public final Builder temporarySubscriptions(Boolean temporarySubscriptions) {
            this.temporarySubscriptions = temporarySubscriptions;
            return this;
        }

        public final Builder nodeTitle(String title) {
            this.nodeTitle = title;
            return this;
        }

        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        protected final Builder self() {
            return this;
        }

        public final NodeConfiguration build() {
            return this.build(DataForm.Type.SUBMIT);
        }

        public final NodeConfiguration build(DataForm.Type formType) {
            ArrayDeque<DataForm.Field> fields = new ArrayDeque<DataForm.Field>();
            if (this.accessModel != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.ACCESS_MODEL).value(this.accessModel.name().toLowerCase()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.bodyXslt != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.BODY_XSLT).value(this.bodyXslt.toString()).build());
            }
            if (this.childrenAssociationPolicy != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.CHILDREN_ASSOCIATION_POLICY).value(this.childrenAssociationPolicy.name().toLowerCase()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.childrenAssociationWhitelist != null && !this.childrenAssociationWhitelist.isEmpty()) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.CHILDREN_ASSOCIATION_WHITELIST).valuesJid(this.childrenAssociationWhitelist).build());
            }
            if (this.children != null && !this.children.isEmpty()) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.CHILDREN).values(this.children).build());
            }
            if (this.childrenMax != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.CHILDREN_MAX).value(this.childrenMax.toString()).build());
            }
            if (this.collection != null && !this.collection.isEmpty()) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.COLLECTION).values(this.collection).build());
            }
            if (this.contacts != null && !this.contacts.isEmpty()) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.CONTACT).valuesJid(this.contacts).build());
            }
            if (this.dataformXslt != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.DATAFORM_XSLT).value(this.dataformXslt.toString()).build());
            }
            if (this.deliverNotifications != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.DELIVER_NOTIFICATIONS).value(this.deliverNotifications.booleanValue()).build());
            }
            if (this.deliverPayloads != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.DELIVER_PAYLOADS).value(this.deliverPayloads.booleanValue()).build());
            }
            if (this.description != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.DESCRIPTION).value(this.description).build());
            }
            if (this.itemExpire != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.ITEM_EXPIRE).value(this.itemExpire.toString()).build());
            }
            if (this.itemReply != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.ITEM_REPLY).value(this.itemReply.name().toLowerCase()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.language != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.LANGUAGE).value(this.language).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.maxItems != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.MAX_ITEMS).value(this.maxItems.toString()).build());
            }
            if (this.maxPayloadSize != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.MAX_PAYLOAD_SIZE).value(this.maxPayloadSize.toString()).build());
            }
            if (this.nodeType != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.NODE_TYPE).value(this.nodeType.name().toLowerCase()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.notificationType != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.NOTIFICATION_TYPE).value(this.notificationType.name().toLowerCase()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.notifyConfig != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.NOTIFY_CONFIG).value(this.notifyConfig.booleanValue()).build());
            }
            if (this.notifyDelete != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.NOTIFY_DELETE).value(this.notifyDelete.booleanValue()).build());
            }
            if (this.notifyRetract != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.NOTIFY_RETRACT).value(this.notifyRetract.booleanValue()).build());
            }
            if (this.notifySub != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.NOTIFY_SUB).value(this.notifySub.booleanValue()).build());
            }
            if (this.persistItems != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.PERSIST_ITEMS).value(this.persistItems.booleanValue()).build());
            }
            if (this.presenceBasedDelivery != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.PRESENCE_BASED_DELIVERY).value(this.presenceBasedDelivery.booleanValue()).build());
            }
            if (this.publisherModel != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.PUBLISH_MODEL).value(this.publisherModel.name().toLowerCase()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.purgeOffline != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.PURGE_OFFLINE).value(this.purgeOffline.booleanValue()).build());
            }
            if (this.rosterGroupsAllowed != null && !this.rosterGroupsAllowed.isEmpty()) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.ROSTER_GROUPS_ALLOWED).values(this.rosterGroupsAllowed).type(DataForm.Field.Type.LIST_MULTI).build());
            }
            if (this.sendLastPublishedItem != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.SEND_LAST_PUBLISHED_ITEM).value(this.sendLastPublishedItem.name().toLowerCase()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.temporarySubscriptions != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.TEMPSUB).value(this.temporarySubscriptions.booleanValue()).build());
            }
            if (this.allowSubscriptions != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.SUBSCRIBE).value(this.allowSubscriptions.booleanValue()).build());
            }
            if (this.nodeTitle != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.TITLE).value(this.nodeTitle).build());
            }
            if (this.type != null) {
                fields.add(DataForm.Field.builder().name(NodeConfiguration.TYPE).value(this.type).build());
            }
            ((Builder)((Builder)this.fields(fields)).formType(NodeConfiguration.FORM_TYPE)).type(formType);
            return new NodeConfiguration(new DataForm((DataForm.Builder)this));
        }
    }
}

