/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model;

import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.extensions.data.StandardizedDataForm;
import rocks.xmpp.extensions.data.model.DataForm;

public final class SubscribeOptions
implements StandardizedDataForm {
    private static final String FORM_TYPE = "http://jabber.org/protocol/pubsub#subscribe_options";
    private static final String DELIVER = "pubsub#deliver";
    private static final String DIGEST = "pubsub#digest";
    private static final String DIGEST_FREQUENCY = "pubsub#digest_frequency";
    private static final String EXPIRE = "pubsub#expire";
    private static final String INCLUDE_BODY = "pubsub#include_body";
    private static final String SHOW_VALUES = "pubsub#show-values";
    private static final String SUBSCRIPTION_TYPE = "pubsub#subscription_type";
    private static final String SUBSCRIPTION_DEPTH = "pubsub#subscription_depth";
    private final DataForm dataForm;

    public SubscribeOptions(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final String getFormType() {
        return FORM_TYPE;
    }

    public final DataForm getDataForm() {
        return this.dataForm;
    }

    public final Boolean isDeliver() {
        return this.dataForm.findValueAsBoolean(DELIVER);
    }

    public Boolean isDigest() {
        return this.dataForm.findValueAsBoolean(DIGEST);
    }

    public final Integer getDigestFrequency() {
        return this.dataForm.findValueAsInteger(DIGEST_FREQUENCY);
    }

    public final Instant getExpire() {
        DataForm.Field field = this.dataForm.findField(EXPIRE);
        if (field != null && !field.getValues().isEmpty() && field.getValues().get(0) != null && !((String)field.getValues().get(0)).equals("presence")) {
            return field.getValueAsInstant();
        }
        return null;
    }

    public final boolean isIncludeBody() {
        return this.dataForm.findValueAsBoolean(INCLUDE_BODY);
    }

    public final List<Presence.Show> getShowValues() {
        List values = this.dataForm.findValues(SHOW_VALUES);
        ArrayList<Presence.Show> list = new ArrayList<Presence.Show>();
        for (String value : values) {
            if ("online".equals(value)) {
                list.add(null);
                continue;
            }
            list.add(Presence.Show.valueOf((String)value.toUpperCase()));
        }
        return list;
    }

    public final SubscriptionType getSubscriptionType() {
        String value = this.dataForm.findValue(SUBSCRIPTION_TYPE);
        if (value != null) {
            return SubscriptionType.valueOf(value.toUpperCase());
        }
        return null;
    }

    public final Integer getSubscriptionDepth() {
        String value = this.dataForm.findValue(SUBSCRIPTION_DEPTH);
        if ("all".equals(value)) {
            return -1;
        }
        if (value != null) {
            return Integer.valueOf(value);
        }
        return null;
    }

    public final boolean isTemporary() {
        DataForm.Field field = this.dataForm.findField(EXPIRE);
        return field != null && !field.getValues().isEmpty() && field.getValues().get(0) != null && ((String)field.getValues().get(0)).equals("presence");
    }

    public final Builder toBuilder() {
        return SubscribeOptions.builder().deliver(this.isDeliver()).digest(this.isDigest()).digestFrequency(this.getDigestFrequency()).expireAt(this.getExpire()).includeBody(this.isIncludeBody()).showValues(this.getShowValues()).subscriptionDepth(this.getSubscriptionDepth()).subscriptionType(this.getSubscriptionType()).temporary(this.isTemporary());
    }

    public static final class Builder
    extends DataForm.Builder<Builder> {
        private Boolean deliver;
        private Boolean digest;
        private Integer digestFrequency;
        private Boolean includeBody;
        private Collection<Presence.Show> showValues;
        private Instant expireAt;
        private Boolean temporary;
        private SubscriptionType subscriptionType;
        private Integer subscriptionDepth;

        private Builder() {
        }

        public final Builder deliver(boolean deliver) {
            this.deliver = deliver;
            return this;
        }

        public final Builder digest(boolean digest) {
            this.digest = digest;
            return this;
        }

        public final Builder digestFrequency(Integer digestFrequency) {
            this.digestFrequency = digestFrequency;
            return this;
        }

        public final Builder includeBody(boolean includeBody) {
            this.includeBody = includeBody;
            return this;
        }

        public final Builder showValues(Collection<Presence.Show> showValues) {
            this.showValues = showValues;
            return this;
        }

        public final Builder expireAt(Instant expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        public final Builder temporary(boolean temporary) {
            this.temporary = temporary;
            return this;
        }

        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        public final Builder subscriptionDepth(Integer subscriptionDepth) {
            this.subscriptionDepth = subscriptionDepth;
            return this;
        }

        protected final Builder self() {
            return this;
        }

        public final SubscribeOptions build() {
            DataForm.Field.Builder fieldBuilder;
            ArrayDeque<DataForm.Field> fields = new ArrayDeque<DataForm.Field>();
            if (this.deliver != null) {
                fields.add(DataForm.Field.builder().name(SubscribeOptions.DELIVER).value(this.deliver.booleanValue()).build());
            }
            if (this.digest != null) {
                fields.add(DataForm.Field.builder().name(SubscribeOptions.DIGEST).value(this.digest.booleanValue()).build());
            }
            if (this.digestFrequency != null) {
                fields.add(DataForm.Field.builder().name(SubscribeOptions.DIGEST_FREQUENCY).value(this.digestFrequency.intValue()).build());
            }
            if (this.temporary != null && this.temporary.booleanValue()) {
                fields.add(DataForm.Field.builder().name(SubscribeOptions.EXPIRE).value("presence").build());
            } else if (this.expireAt != null) {
                fields.add(DataForm.Field.builder().name(SubscribeOptions.EXPIRE).value(this.expireAt).build());
            }
            if (this.includeBody != null) {
                fields.add(DataForm.Field.builder().name(SubscribeOptions.INCLUDE_BODY).value(this.includeBody.booleanValue()).build());
            }
            if (this.showValues != null && !this.showValues.isEmpty()) {
                fieldBuilder = DataForm.Field.builder().name(SubscribeOptions.SHOW_VALUES);
                ArrayDeque<String> values = new ArrayDeque<String>();
                for (Presence.Show show : this.showValues) {
                    if (show != null) {
                        values.add(show.name().toLowerCase());
                        continue;
                    }
                    values.add("online");
                }
                fieldBuilder.values(values).type(DataForm.Field.Type.LIST_MULTI);
                fields.add(fieldBuilder.build());
            }
            if (this.subscriptionType != null) {
                fields.add(DataForm.Field.builder().name(SubscribeOptions.SUBSCRIPTION_TYPE).value(this.subscriptionType.name().toLowerCase()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.subscriptionDepth != null) {
                fieldBuilder = DataForm.Field.builder().name(SubscribeOptions.SUBSCRIPTION_DEPTH);
                if (this.subscriptionDepth < 1) {
                    fieldBuilder.value("all");
                } else {
                    fieldBuilder.value(this.subscriptionDepth.toString());
                }
                fieldBuilder.type(DataForm.Field.Type.LIST_SINGLE);
                fields.add(fieldBuilder.build());
            }
            ((Builder)((Builder)this.fields(fields)).formType(SubscribeOptions.FORM_TYPE)).type(DataForm.Type.SUBMIT);
            return new SubscribeOptions(new DataForm((DataForm.Builder)this));
        }
    }

    public static enum SubscriptionType {
        ITEMS,
        NODES;

    }
}

