/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model.event;

import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.SubscriptionState;
import rocks.xmpp.util.adapters.InstantAdapter;

@XmlRootElement(name="event")
public final class Event {
    @XmlElements(value={@XmlElement(name="configuration", type=Configuration.class), @XmlElement(name="delete", type=Delete.class), @XmlElement(name="items", type=Items.class), @XmlElement(name="purge", type=Purge.class), @XmlElement(name="subscription", type=SubscriptionInfo.class)})
    private final PubSubEventChildElement type;

    private Event() {
        this.type = null;
    }

    private Event(PubSubEventChildElement type) {
        this.type = type;
    }

    public static Event withConfiguration(String node, DataForm configuration) {
        return new Event(new Configuration(node, configuration));
    }

    public static Event withDeletion(String node) {
        return new Event(new Delete(node));
    }

    public static Event withDeletion(String node, URI redirectUri) {
        return new Event(new Delete(node, redirectUri));
    }

    public static Event withItem(String node, Object payload, String id, Jid publisher) {
        return new Event(new Items(node, Collections.singletonList(new ItemElement(Objects.requireNonNull(payload), id, publisher)), null));
    }

    public static Event withItems(String node, List<Item> items) {
        return new Event(new Items(node, items, null));
    }

    public static Event withRetractedItems(String node, List<String> deletedItemIds) {
        return new Event(new Items(node, null, deletedItemIds));
    }

    public static Event withPurge(String node) {
        return new Event(new Purge(node));
    }

    public static Event withSubscription(String node, Jid jid, SubscriptionState subscription) {
        return new Event(new SubscriptionInfo(node, null, jid, null, subscription));
    }

    public static Event withSubscription(String node, Jid jid, SubscriptionState subscription, Instant expiry, String subid) {
        return new Event(new SubscriptionInfo(node, expiry, jid, subid, subscription));
    }

    public final String getNode() {
        return this.type != null ? this.type.getNode() : null;
    }

    public final boolean isConfiguration() {
        return this.type instanceof Configuration;
    }

    public final boolean isDelete() {
        return this.type instanceof Delete;
    }

    public final boolean isPurge() {
        return this.type instanceof Purge;
    }

    public final boolean hasItems() {
        return this.type instanceof Items && ((Items)this.type).item != null;
    }

    public final boolean isRetract() {
        return this.type instanceof Items && ((Items)this.type).retract != null;
    }

    public final Subscription getSubscription() {
        if (this.type instanceof SubscriptionInfo) {
            return (SubscriptionInfo)this.type;
        }
        return null;
    }

    public final List<Item> getItems() {
        if (this.type instanceof Items && ((Items)this.type).item != null) {
            return Collections.unmodifiableList(((Items)this.type).item);
        }
        return Collections.emptyList();
    }

    public final List<String> getRetractedItems() {
        if (this.type instanceof Items && ((Items)this.type).retract != null) {
            return Collections.unmodifiableList(((Items)this.type).retract.stream().map(retract -> retract.id).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    public final DataForm getConfigurationForm() {
        if (this.type instanceof Configuration) {
            return ((Configuration)this.type).dataForm;
        }
        return null;
    }

    public final URI getRedirectUri() {
        if (this.type instanceof Delete && ((Delete)this.type).redirect != null) {
            return ((Delete)this.type).redirect.uri;
        }
        return null;
    }

    @XmlTransient
    private static abstract class PubSubEventChildElement {
        @XmlAttribute
        private final String node;

        private PubSubEventChildElement() {
            this.node = null;
        }

        private PubSubEventChildElement(String node) {
            this.node = Objects.requireNonNull(node);
        }

        public final String getNode() {
            return this.node;
        }
    }

    private static final class ItemElement
    implements Item {
        @XmlAnyElement(lax=true)
        private final Object object;
        @XmlAttribute
        private final String id;
        @XmlAttribute
        private final Jid publisher;

        private ItemElement() {
            this.object = null;
            this.id = null;
            this.publisher = null;
        }

        private ItemElement(Object object, String id, Jid publisher) {
            this.object = object;
            this.id = id;
            this.publisher = publisher;
        }

        @Override
        public final Object getPayload() {
            return this.object;
        }

        @Override
        public final String getId() {
            return this.id;
        }

        @Override
        public final Jid getPublisher() {
            return this.publisher;
        }
    }

    private static final class SubscriptionInfo
    extends PubSubEventChildElement
    implements Subscription {
        @XmlAttribute
        @XmlJavaTypeAdapter(value=InstantAdapter.class)
        private final Instant expiry;
        @XmlAttribute
        private final Jid jid;
        @XmlAttribute
        private final String subid;
        @XmlAttribute
        private final SubscriptionState subscription;

        private SubscriptionInfo() {
            this.expiry = null;
            this.jid = null;
            this.subid = null;
            this.subscription = null;
        }

        private SubscriptionInfo(String node, Instant expiry, Jid jid, String subid, SubscriptionState subscription) {
            super(node);
            this.expiry = expiry;
            this.jid = jid;
            this.subid = subid;
            this.subscription = subscription;
        }

        @Override
        public final Jid getJid() {
            return this.jid;
        }

        @Override
        public final String getSubId() {
            return this.subid;
        }

        @Override
        public final SubscriptionState getSubscriptionState() {
            return this.subscription;
        }

        @Override
        public final Instant getExpiry() {
            return this.expiry;
        }

        @Override
        public final boolean isConfigurationRequired() {
            return false;
        }

        @Override
        public final boolean isConfigurationSupported() {
            return false;
        }
    }

    private static final class Retract {
        @XmlAttribute
        private final String id;

        private Retract() {
            this.id = null;
        }

        private Retract(String id) {
            this.id = Objects.requireNonNull(id);
        }
    }

    private static final class Purge
    extends PubSubEventChildElement {
        private Purge() {
        }

        private Purge(String node) {
            super(node);
        }
    }

    private static final class Items
    extends PubSubEventChildElement {
        private final List<ItemElement> item;
        private final List<Retract> retract;

        private Items() {
            this.item = null;
            this.retract = null;
        }

        private Items(String node, Collection<Item> items, Collection<String> retractedItems) {
            super(Objects.requireNonNull(node));
            this.item = items != null ? items.stream().map(i -> new ItemElement(i.getPayload(), i.getId(), i.getPublisher())).collect(Collectors.toList()) : null;
            this.retract = retractedItems != null ? retractedItems.stream().map(x$0 -> new Retract((String)x$0)).collect(Collectors.toList()) : null;
        }
    }

    private static final class Delete
    extends PubSubEventChildElement {
        private final Redirect redirect;

        private Delete() {
            this.redirect = null;
        }

        private Delete(String node) {
            super(node);
            this.redirect = null;
        }

        private Delete(String node, URI redirect) {
            super(node);
            this.redirect = new Redirect(redirect);
        }

        private static final class Redirect {
            @XmlAttribute
            private final URI uri;

            private Redirect() {
                this.uri = null;
            }

            private Redirect(URI uri) {
                this.uri = Objects.requireNonNull(uri);
            }
        }
    }

    private static final class Configuration
    extends PubSubEventChildElement {
        @XmlElementRef
        private final DataForm dataForm;

        private Configuration() {
            this.dataForm = null;
        }

        private Configuration(String node, DataForm dataForm) {
            super(node);
            this.dataForm = dataForm;
        }
    }
}

