/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.softwareinfo;

import java.util.Arrays;
import rocks.xmpp.extensions.data.StandardizedDataForm;
import rocks.xmpp.extensions.data.mediaelement.model.Media;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.softwareinfo.SoftwareInfo;

public final class SoftwareInformation
implements StandardizedDataForm,
SoftwareInfo {
    static final String FORM_TYPE = "urn:xmpp:dataforms:softwareinfo";
    static final String ICON = "icon";
    static final String OS = "os";
    static final String OS_VERSION = "os_version";
    static final String SOFTWARE = "software";
    static final String SOFTWARE_VERSION = "software_version";
    private final DataForm dataForm;

    public SoftwareInformation(Media icon, String software, String softwareVersion) {
        this(icon, software, softwareVersion, System.getProperty("os.name"), System.getProperty("os.version"));
    }

    public SoftwareInformation(Media icon, String software, String softwareVersion, String os, String osVersion) {
        this.dataForm = new DataForm(DataForm.Type.RESULT, Arrays.asList(DataForm.Field.builder().name("FORM_TYPE").value(FORM_TYPE).type(DataForm.Field.Type.HIDDEN).build(), DataForm.Field.builder().name(ICON).media(icon).build(), DataForm.Field.builder().name(OS).value(os).build(), DataForm.Field.builder().name(OS_VERSION).value(osVersion).build(), DataForm.Field.builder().name(SOFTWARE).value(software).build(), DataForm.Field.builder().name(SOFTWARE_VERSION).value(softwareVersion).build()));
    }

    public SoftwareInformation(DataForm dataForm) {
        if (!FORM_TYPE.equals(dataForm.getFormType())) {
            throw new IllegalArgumentException("Data form FORM_TYPE must be 'urn:xmpp:dataforms:softwareinfo'");
        }
        this.dataForm = dataForm;
    }

    public final Media getIcon() {
        DataForm.Field iconField = this.dataForm.findField(ICON);
        if (iconField != null) {
            return iconField.getMedia();
        }
        return null;
    }

    @Override
    public final String getOs() {
        return this.dataForm.findValue(OS);
    }

    public final String getOsVersion() {
        return this.dataForm.findValue(OS_VERSION);
    }

    @Override
    public final String getSoftware() {
        return this.dataForm.findValue(SOFTWARE);
    }

    @Override
    public final String getSoftwareVersion() {
        return this.dataForm.findValue(SOFTWARE_VERSION);
    }

    public final String getFormType() {
        return FORM_TYPE;
    }

    public final DataForm getDataForm() {
        return this.dataForm;
    }

    public final String toString() {
        return this.dataForm.toString();
    }
}

