/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.tune.model;

import java.net.URI;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public final class Tune {
    public static final String NAMESPACE = "http://jabber.org/protocol/tune";
    private final String artist;
    private final Integer length;
    private final Integer rating;
    private final String source;
    private final String title;
    private final String track;
    private final URI uri;

    private Tune() {
        this(null, null);
    }

    public Tune(String artist, String title) {
        this(artist, title, null, null, null, null, null);
    }

    public Tune(String artist, String title, Integer length, Integer rating, String source, String track, URI uri) {
        this.artist = artist;
        this.title = title;
        this.length = length;
        if (rating != null && (rating < 0 || rating > 10)) {
            throw new IllegalArgumentException("rating must not be greater than 10.");
        }
        this.rating = rating;
        this.source = source;
        this.track = track;
        this.uri = uri;
    }

    public final String getArtist() {
        return this.artist;
    }

    public final Integer getLength() {
        return this.length;
    }

    public final Integer getRating() {
        return this.rating;
    }

    public final String getSource() {
        return this.source;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getTrack() {
        return this.track;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.artist != null) {
            sb.append("Artist: ").append(this.artist).append("; ");
        }
        if (this.title != null) {
            sb.append("Title: ").append(this.title).append("; ");
        }
        if (this.length != null) {
            sb.append("Length: ").append(this.length).append("; ");
        }
        if (this.rating != null) {
            sb.append("Rating: ").append(this.rating).append("; ");
        }
        if (this.source != null) {
            sb.append("Source: ").append(this.source).append("; ");
        }
        if (this.track != null) {
            sb.append("Track: ").append(this.track).append("; ");
        }
        if (this.uri != null) {
            sb.append("URI: ").append(this.uri);
        }
        return sb.toString();
    }
}

