/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014 Christian Schudt
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package rocks.xmpp.extensions.jingle.transports.ibb.model;

import rocks.xmpp.extensions.jingle.transports.model.TransportMethod;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * @author Christian Schudt
 */
@XmlRootElement(name = "transport")
public final class InBandBytestreamsTransportMethod extends TransportMethod {

    @XmlAttribute(name = "block-size")
    private Integer blockSize;

    @XmlAttribute
    private String sid;

    @XmlAttribute
    private StanzaType stanza;

    private InBandBytestreamsTransportMethod() {
    }

    public InBandBytestreamsTransportMethod(String sid, int blockSize) {
        this.sid = sid;
        this.blockSize = blockSize;
    }

    public Integer getBlockSize() {
        return blockSize;
    }

    public String getSessionId() {
        return sid;
    }

    public StanzaType getStanzaType() {
        return stanza;
    }

    public enum StanzaType {
        @XmlEnumValue("iq")
        IQ,
        @XmlEnumValue("message")
        MESSAGE
    }
}
