/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.s5b.model;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.bytestreams.s5b.model.StreamHost;
import rocks.xmpp.extensions.bytestreams.s5b.model.StreamHostUsed;

@XmlRootElement(name="query")
public final class Socks5ByteStream {
    public static final String NAMESPACE = "http://jabber.org/protocol/bytestreams";
    @XmlElement(name="streamhost")
    private List<StreamHost> streamHosts = new ArrayList<StreamHost>();
    @XmlElement(name="streamhost-used")
    private StreamHostUsed streamHostUsed;
    @XmlAttribute(name="dstaddr")
    private String dstaddr;
    @XmlElement(name="activate")
    private Jid activate;
    @XmlAttribute(name="mode")
    private Mode mode;
    @XmlAttribute(name="sid")
    private String sid;

    public Socks5ByteStream() {
    }

    public Socks5ByteStream(String sessionId, List<StreamHost> streamHosts, String dstaddr) {
        this.sid = sessionId;
        this.streamHosts.addAll(streamHosts);
        this.dstaddr = dstaddr;
    }

    public static Socks5ByteStream activate(String sessionId, Jid jid) {
        Socks5ByteStream socks5ByteStream = new Socks5ByteStream();
        socks5ByteStream.sid = sessionId;
        socks5ByteStream.activate = jid;
        return socks5ByteStream;
    }

    public static Socks5ByteStream streamHostUsed(Jid jid) {
        Socks5ByteStream socks5ByteStream = new Socks5ByteStream();
        socks5ByteStream.streamHostUsed = new StreamHostUsed(jid);
        return socks5ByteStream;
    }

    public static String hash(String sessionId, Jid requesterJid, Jid targetJid) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(sessionId.getBytes());
            messageDigest.update(requesterJid.toEscapedString().getBytes());
            messageDigest.update(targetJid.toEscapedString().getBytes());
            return new BigInteger(1, messageDigest.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public List<StreamHost> getStreamHosts() {
        return this.streamHosts;
    }

    public String getSessionId() {
        return this.sid;
    }

    public Jid getStreamHostUsed() {
        return this.streamHostUsed != null ? this.streamHostUsed.jid : null;
    }

    public static enum Mode {
        TCP,
        UDP;

    }
}

