/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps.model;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;

@XmlRootElement(name="c")
public final class EntityCapabilities
extends StreamFeature {
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    @XmlAttribute
    private String hash;
    @XmlAttribute
    private String node;
    @XmlAttribute
    private String ver;

    private EntityCapabilities() {
    }

    public EntityCapabilities(String node, String hash, String ver) {
        this.node = node;
        this.hash = hash;
        this.ver = ver;
    }

    public static String getVerificationString(InfoNode infoNode, MessageDigest messageDigest) {
        ArrayList identities = new ArrayList(infoNode.getIdentities());
        ArrayList features = new ArrayList(infoNode.getFeatures());
        ArrayList dataForms = new ArrayList(infoNode.getExtensions());
        StringBuilder sb = new StringBuilder();
        Collections.sort(identities);
        for (Identity identity : identities) {
            if (identity.getCategory() != null) {
                sb.append(identity.getCategory());
            }
            sb.append("/");
            if (identity.getType() != null) {
                sb.append(identity.getType());
            }
            sb.append("/");
            if (identity.getLanguage() != null) {
                sb.append(identity.getLanguage());
            }
            sb.append("/");
            if (identity.getName() != null) {
                sb.append(identity.getName());
            }
            sb.append("<");
        }
        Collections.sort(features);
        for (Feature feature : features) {
            if (feature.getVar() != null) {
                sb.append(feature.getVar());
            }
            sb.append("<");
        }
        Collections.sort(dataForms);
        for (DataForm dataForm : dataForms) {
            Collections.sort(dataForm.getFields());
            if (dataForm.getFields().isEmpty() || !"FORM_TYPE".equals(((DataForm.Field)dataForm.getFields().get(0)).getVar()) || ((DataForm.Field)dataForm.getFields().get(0)).getType() != DataForm.Field.Type.HIDDEN) continue;
            for (DataForm.Field field : dataForm.getFields()) {
                if (!"FORM_TYPE".equals(field.getVar())) {
                    sb.append(field.getVar());
                    sb.append("<");
                    Collections.sort(field.getValues());
                }
                for (String value : field.getValues()) {
                    sb.append(value);
                    sb.append("<");
                }
            }
        }
        String plainString = sb.toString();
        messageDigest.reset();
        return DatatypeConverter.printBase64Binary((byte[])messageDigest.digest(plainString.getBytes()));
    }

    public String getHashingAlgorithm() {
        return this.hash;
    }

    public void setHashingAlgorithm(String hash) {
        this.hash = hash;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getVerificationString() {
        return this.ver;
    }

    public void setVerificationString(String verificationString) {
        this.ver = verificationString;
    }

    public int getPriority() {
        return 0;
    }

    public String toString() {
        return this.ver;
    }
}

