/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle.apps.rtp.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import rocks.xmpp.extensions.jingle.apps.model.ApplicationFormat;
import rocks.xmpp.extensions.jingle.apps.rtp.model.errors.CryptoRequired;
import rocks.xmpp.extensions.jingle.apps.rtp.model.errors.InvalidCrypto;
import rocks.xmpp.extensions.jingle.apps.rtp.model.info.Active;
import rocks.xmpp.extensions.jingle.apps.rtp.model.info.Hold;
import rocks.xmpp.extensions.jingle.apps.rtp.model.info.Mute;
import rocks.xmpp.extensions.jingle.apps.rtp.model.info.Ringing;
import rocks.xmpp.extensions.jingle.apps.rtp.model.info.Unhold;
import rocks.xmpp.extensions.jingle.apps.rtp.model.info.Unmute;

@XmlRootElement(name="description")
@XmlSeeAlso(value={InvalidCrypto.class, CryptoRequired.class, Active.class, Hold.class, Unhold.class, Mute.class, Unmute.class, Ringing.class})
public final class Rtp
extends ApplicationFormat {
    @XmlAttribute(name="media")
    private String media;
    @XmlAttribute(name="ssrc")
    private String ssrc;
    @XmlElement(name="payload-type")
    private List<PayloadType> payloadTypes = new ArrayList<PayloadType>();
    @XmlElement(name="encryption")
    private Encryption encryption;
    @XmlElement(name="bandwidth")
    private Bandwidth bandwidth;

    private Rtp() {
    }

    public Rtp(String media) {
        this.media = media;
    }

    public Rtp(String media, String ssrc, Bandwidth bandwidth, Encryption encryption) {
        this.media = media;
        this.ssrc = ssrc;
        this.bandwidth = bandwidth;
        this.encryption = encryption;
    }

    public String getMedia() {
        return this.media;
    }

    public List<PayloadType> getPayloadTypes() {
        return this.payloadTypes;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public String getSynchronizationSource() {
        return this.ssrc;
    }

    public Bandwidth getBandwidth() {
        return this.bandwidth;
    }

    public static final class PayloadType {
        @XmlElement(name="parameter")
        private List<Parameter> parameters = new ArrayList<Parameter>();
        @XmlAttribute(name="channels")
        private int channels = 1;
        @XmlAttribute(name="clockrate")
        private long clockrate;
        @XmlAttribute(name="id")
        private int id;
        @XmlAttribute(name="maxptime")
        private long maxptime;
        @XmlAttribute(name="name")
        private String name;
        @XmlAttribute(name="ptime")
        private long ptime;

        private PayloadType() {
        }

        public PayloadType(int id) {
            this.id = id;
        }

        public PayloadType(int id, int channels, long clockRate, String name, long packetTime, long maxPacketTime) {
            this.id = id;
            this.channels = channels;
            this.clockrate = clockRate;
            this.ptime = packetTime;
            this.maxptime = maxPacketTime;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public long getClockRate() {
            return this.clockrate;
        }

        public int getChannels() {
            return this.channels;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public int getId() {
            return this.id;
        }

        public long getMaxPacketTime() {
            return this.maxptime;
        }

        public long getPacketTime() {
            return this.ptime;
        }

        public static final class Parameter {
            @XmlAttribute(name="name")
            private String name;
            @XmlAttribute(name="value")
            private String value;

            private Parameter() {
            }

            public Parameter(String name, String value) {
                this.name = name;
                this.value = value;
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }
        }
    }

    public static final class Bandwidth {
        @XmlAttribute(name="type")
        private String type;

        private Bandwidth() {
        }

        public Bandwidth(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static final class Crypto {
        @XmlAttribute(name="crypto-suite")
        private String cryptoSuite;
        @XmlAttribute(name="key-params")
        private String keyParams;
        @XmlAttribute(name="session-params")
        private String sessionParams;
        @XmlAttribute(name="tag")
        private String tag;

        private Crypto() {
        }

        public Crypto(String cryptoSuite, String keyParams, String tag) {
            this.cryptoSuite = cryptoSuite;
            this.keyParams = keyParams;
            this.tag = tag;
        }

        public String getCryptoSuite() {
            return this.cryptoSuite;
        }

        public String getKeyParameters() {
            return this.keyParams;
        }

        public String getSessionParameters() {
            return this.sessionParams;
        }

        public String getTag() {
            return this.tag;
        }
    }

    public static final class Encryption {
        @XmlElement(name="crypto")
        private List<Crypto> cryptos = new ArrayList<Crypto>();

        public List<Crypto> getCrypto() {
            return this.cryptos;
        }
    }
}

