/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.jingle.apps.model.ApplicationFormat;
import rocks.xmpp.extensions.jingle.transports.model.TransportMethod;

@XmlRootElement(name="jingle")
public final class Jingle {
    @XmlElement(name="content")
    private final List<Content> contents = new ArrayList<Content>();
    @XmlAttribute(name="action")
    private Action action;
    @XmlAttribute(name="initiator")
    private Jid initiator;
    @XmlAttribute(name="responder")
    private Jid responder;
    @XmlAttribute(name="sid")
    private String sessionId;
    @XmlElement(name="reason")
    private Reason reason;
    @XmlAnyElement(lax=true)
    private Object payload;

    private Jingle() {
    }

    public Jingle(String sessionId, Action action, Reason reason) {
        this.sessionId = sessionId;
        this.action = action;
        this.reason = reason;
    }

    public Jingle(String sessionId, Action action, Object payload) {
        this.sessionId = sessionId;
        this.action = action;
        this.payload = payload;
    }

    public static Jingle initiator(Jid initiator, String sessionId, Action action, List<Content> contents) {
        Jingle jingle = new Jingle();
        jingle.sessionId = sessionId;
        jingle.action = action;
        jingle.initiator = initiator;
        jingle.contents.addAll(contents);
        return jingle;
    }

    public static Jingle responder(Jid responder, String sessionId, Action action, List<Content> contents) {
        Jingle jingle = new Jingle();
        jingle.sessionId = sessionId;
        jingle.action = action;
        jingle.responder = responder;
        jingle.contents.addAll(contents);
        return jingle;
    }

    public Action getAction() {
        return this.action;
    }

    public Jid getInitiator() {
        return this.initiator;
    }

    public Jid getResponder() {
        return this.responder;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public List<Content> getContents() {
        return this.contents;
    }

    public Reason getReason() {
        return this.reason;
    }

    public void setReason(Reason reason) {
        this.reason = reason;
    }

    public Object getPayload() {
        return this.payload;
    }

    public static final class Reason {
        @XmlElements(value={@XmlElement(name="alternative-session", type=AlternativeSession.class), @XmlElement(name="busy", type=Busy.class), @XmlElement(name="cancel", type=Cancel.class), @XmlElement(name="connectivity-error", type=ConnectivityError.class), @XmlElement(name="decline", type=Decline.class), @XmlElement(name="expired", type=Expired.class), @XmlElement(name="failed-application", type=FailedApplication.class), @XmlElement(name="failed-transport", type=FailedTransport.class), @XmlElement(name="general-error", type=GeneralError.class), @XmlElement(name="gone", type=Gone.class), @XmlElement(name="incompatible-parameters", type=IncompatibleParameters.class), @XmlElement(name="media-error", type=MediaError.class), @XmlElement(name="security-error", type=SecurityError.class), @XmlElement(name="success", type=Success.class), @XmlElement(name="timeout", type=Timeout.class), @XmlElement(name="unsupported-applications", type=UnsupportedApplications.class), @XmlElement(name="unsupported-transports", type=UnsupportedTransports.class)})
        private Condition condition;
        @XmlElement(name="text")
        private String text;
        @XmlAnyElement(lax=true)
        private Object extension;

        private Reason() {
        }

        public Reason(Condition condition) {
            this.condition = condition;
        }

        public Reason(Condition condition, String text) {
            this.condition = condition;
            this.text = text;
        }

        public Reason(Condition condition, String text, Object extension) {
            this.condition = condition;
            this.text = text;
            this.extension = extension;
        }

        public Condition getType() {
            return this.condition;
        }

        public String getText() {
            return this.text;
        }

        public Object getExtension() {
            return this.extension;
        }

        public static final class UnsupportedTransports
        extends Condition {
        }

        public static final class UnsupportedApplications
        extends Condition {
        }

        public static final class Timeout
        extends Condition {
        }

        public static final class Success
        extends Condition {
        }

        public static final class SecurityError
        extends Condition {
        }

        public static final class MediaError
        extends Condition {
        }

        public static final class IncompatibleParameters
        extends Condition {
        }

        public static final class Gone
        extends Condition {
        }

        public static final class GeneralError
        extends Condition {
        }

        public static final class FailedTransport
        extends Condition {
        }

        public static final class FailedApplication
        extends Condition {
        }

        public static final class Expired
        extends Condition {
        }

        public static final class Decline
        extends Condition {
        }

        public static final class ConnectivityError
        extends Condition {
        }

        public static final class Cancel
        extends Condition {
        }

        public static final class Busy
        extends Condition {
        }

        public static final class AlternativeSession
        extends Condition {
            @XmlElement(name="sid")
            private String sessionId;

            public AlternativeSession(String sessionId) {
                this.sessionId = sessionId;
            }

            public String getSessionId() {
                return this.sessionId;
            }
        }

        public static abstract class Condition {
            private Condition() {
            }
        }
    }

    public static final class Content {
        @XmlElementRef
        private ApplicationFormat applicationFormat;
        @XmlElementRef
        private TransportMethod transportMethod;
        @XmlAttribute(name="creator")
        private Creator creator;
        @XmlAttribute(name="disposition")
        private String disposition;
        @XmlAttribute(name="name")
        private String name;
        @XmlAttribute(name="senders")
        private Senders senders;

        private Content() {
        }

        public Content(String name, Creator creator, ApplicationFormat applicationFormat, TransportMethod transportMethod) {
            this(name, creator, applicationFormat, transportMethod, null, null);
        }

        public Content(String name, Creator creator, ApplicationFormat applicationFormat, TransportMethod transportMethod, String disposition, Senders senders) {
            this.name = name;
            this.creator = creator;
            this.applicationFormat = applicationFormat;
            this.transportMethod = transportMethod;
            this.disposition = disposition;
            this.senders = senders;
        }

        public Creator getCreator() {
            return this.creator;
        }

        public String getDisposition() {
            return this.disposition;
        }

        public String getName() {
            return this.name;
        }

        public Senders getSenders() {
            return this.senders;
        }

        public ApplicationFormat getApplicationFormat() {
            return this.applicationFormat;
        }

        public TransportMethod getTransportMethod() {
            return this.transportMethod;
        }

        public static enum Senders {
            BOTH,
            INITIATOR,
            NONE,
            RESPONDER;

        }

        public static enum Creator {
            INITIATOR,
            RESPONDER;

        }
    }

    public static enum Action {
        CONTENT_ACCEPT,
        CONTENT_ADD,
        CONTENT_MODIFY,
        CONTENT_REJECT,
        CONTENT_REMOVE,
        DESCRIPTION_INFO,
        SECURITY_INFO,
        SESSION_ACCEPT,
        SESSION_INFO,
        SESSION_INITIATE,
        SESSION_TERMINATE,
        TRANSPORT_ACCEPT,
        TRANSPORT_INFO,
        TRANSPORT_REJECT,
        TRANSPORT_REPLACE;

    }
}

