/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle.transports.s5b.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.jingle.transports.model.TransportMethod;

@XmlRootElement(name="transport")
public class S5bTransportMethod
extends TransportMethod {
    @XmlElement(name="candidate")
    private final List<Candidate> candidates = new ArrayList<Candidate>();
    @XmlAttribute(name="dstaddr")
    private String dstAddr;
    @XmlAttribute(name="mode")
    private Mode mode = Mode.TCP;
    @XmlAttribute(name="sid")
    private String sessionId;

    public String getDstAddr() {
        return this.dstAddr;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Mode getMode() {
        return this.mode;
    }

    public List<Candidate> getCandidates() {
        return this.candidates;
    }

    private static final class Activated {
        @XmlAttribute(name="cid")
        private String cid;

        private Activated() {
        }
    }

    private static final class CandidateUsed {
        @XmlAttribute(name="cid")
        private String cid;

        private CandidateUsed() {
        }
    }

    public static final class Candidate
    implements Comparable<Candidate> {
        @XmlAttribute(name="cid")
        private String cid;
        @XmlAttribute(name="host")
        private String host;
        @XmlAttribute(name="jid")
        private Jid jid;
        @XmlAttribute(name="port")
        private int port;
        @XmlAttribute(name="priority")
        private int priority;
        @XmlAttribute(name="type")
        private Type type = Type.DIRECT;

        private Candidate() {
        }

        public Candidate(String cid, String host, Jid jid, int localPriority) {
            this.cid = cid;
            this.host = host;
            this.jid = jid;
            this.priority = this.calculatePriority(localPriority);
        }

        public Candidate(String cid, String host, Jid jid, int localPriority, Type type, int port) {
            this.cid = cid;
            this.host = host;
            this.jid = jid;
            this.type = type;
            this.port = port;
            this.priority = this.calculatePriority(localPriority);
        }

        private int calculatePriority(int localPreference) {
            return 65536 * (this.type == null ? Type.DIRECT.getPreferenceValue() : this.type.getPreferenceValue()) + localPreference;
        }

        public String getCid() {
            return this.cid;
        }

        public String getHost() {
            return this.host;
        }

        public Jid getJid() {
            return this.jid;
        }

        public int getPort() {
            return this.port;
        }

        public int getPriority() {
            return this.priority;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public int compareTo(Candidate o) {
            return Integer.compare(o.priority, this.priority);
        }

        public static enum Type {
            ASSISTED(120),
            DIRECT(126),
            PROXY(10),
            TUNNEL(110);

            private final int preferenceValue;

            private Type(int preferenceValue) {
                this.preferenceValue = preferenceValue;
            }

            public int getPreferenceValue() {
                return this.preferenceValue;
            }
        }
    }

    public static enum Mode {
        TCP,
        UDP;

    }
}

