/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc.model;

import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.muc.model.Role;

public final class RequestVoiceForm {
    private static final String FORM_TYPE = "http://jabber.org/protocol/muc#request";
    private static final String ROLE = "muc#role";
    private static final String JID = "muc#jid";
    private static final String ROOM_NICK = "muc#roomnick";
    private static final String REQUEST_ALLOW = "muc#request_allow";
    private final DataForm dataForm;

    public RequestVoiceForm(DataForm dataForm) {
        this.dataForm = dataForm;
        this.dataForm.setFormType(FORM_TYPE);
    }

    public Jid getJid() {
        DataForm.Field field = this.dataForm.findField(JID);
        if (field != null && !field.getValues().isEmpty()) {
            return Jid.valueOf((String)((String)field.getValues().get(0)));
        }
        return null;
    }

    public void setJid(Jid jid) {
        DataForm.Field field = this.dataForm.findField(JID);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.JID_SINGLE, JID, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(jid.toEscapedString());
    }

    public String getRoomNick() {
        DataForm.Field field = this.dataForm.findField(ROOM_NICK);
        if (field != null && !field.getValues().isEmpty()) {
            return (String)field.getValues().get(0);
        }
        return null;
    }

    public void setRoomNick(String roomNick) {
        DataForm.Field field = this.dataForm.findField(ROOM_NICK);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, ROOM_NICK, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(roomNick);
    }

    public Role getRole() {
        DataForm.Field field = this.dataForm.findField(ROLE);
        if (field != null && !field.getValues().isEmpty()) {
            return Role.valueOf(((String)field.getValues().get(0)).toUpperCase());
        }
        return null;
    }

    public void setRole(Role role) {
        DataForm.Field field = this.dataForm.findField(ROLE);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, ROLE, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(role.toString().toLowerCase());
    }

    public boolean isRequestAllowed() {
        DataForm.Field field = this.dataForm.findField(REQUEST_ALLOW);
        return field != null && !field.getValues().isEmpty() && DataForm.parseBoolean((String)((String)field.getValues().get(0)));
    }

    public void setRequestAllowed(boolean requestAllowed) {
        DataForm.Field field = this.dataForm.findField(REQUEST_ALLOW);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.BOOLEAN, REQUEST_ALLOW, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(requestAllowed ? "1" : "0");
    }
}

