/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.muc.model.Role;

public final class RoomConfigurationForm {
    private static final String MAX_HISTORY_FETCH = "muc#maxhistoryfetch";
    private static final String ALLOW_PM = "muc#roomconfig_allowpm";
    private static final String ALLOW_INVITES = "muc#roomconfig_allowinvites";
    private static final String CHANGE_SUBJECT = "muc#roomconfig_changesubject";
    private static final String ENABLE_LOGGING = "muc#roomconfig_enablelogging";
    private static final String GET_MEMBER_LIST = "muc#roomconfig_getmemberlist";
    private static final String LANGUAGE = "muc#roomconfig_lang";
    private static final String PUBSUB = "muc#roomconfig_pubsub";
    private static final String MAX_USERS = "muc#roomconfig_maxusers";
    private static final String MEMBERS_ONLY = "muc#roomconfig_membersonly";
    private static final String MODERATED_ROOM = "muc#roomconfig_moderatedroom";
    private static final String PASSWORD_PROTECTED = "muc#roomconfig_passwordprotectedroom";
    private static final String PERSISTENT_ROOM = "muc#roomconfig_persistentroom";
    private static final String PRESENCE_BROADCAST = "muc#roomconfig_presencebroadcast";
    private static final String PUBLIC_ROOM = "muc#roomconfig_publicroom";
    private static final String ROOM_ADMINS = "muc#roomconfig_roomadmins";
    private static final String ROOM_DESC = "muc#roomconfig_roomdesc";
    private static final String ROOM_NAME = "muc#roomconfig_roomname";
    private static final String ROOM_OWNERS = "muc#roomconfig_roomowners";
    private static final String ROOM_SECRET = "muc#roomconfig_roomsecret";
    private static final String WHOIS = "muc#roomconfig_whois";
    private final DataForm dataForm;

    public RoomConfigurationForm(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public int getMaxHistoryMessages() {
        return this.getAsInteger(MAX_HISTORY_FETCH);
    }

    public void setMaxHistoryMessages(int maxHistoryMessages) {
        DataForm.Field field = this.getOrCreateField(DataForm.Field.Type.TEXT_SINGLE, MAX_HISTORY_FETCH);
        field.getValues().clear();
        field.getValues().add(Integer.toString(maxHistoryMessages));
    }

    private DataForm.Field getOrCreateField(DataForm.Field.Type type, String var) {
        DataForm.Field field = this.dataForm.findField(var);
        if (field == null) {
            field = new DataForm.Field(type, var, new String[0]);
            this.dataForm.getFields().add(field);
        }
        return field;
    }

    private int getAsInteger(String fieldName) {
        DataForm.Field field = this.dataForm.findField(fieldName);
        if (field != null && !field.getValues().isEmpty()) {
            try {
                return Integer.parseInt((String)field.getValues().get(0));
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public Set<Role> getAllowedRolesToSendPrivateMessages() {
        DataForm.Field field = this.dataForm.findField(ALLOW_PM);
        EnumSet<Role> roles = EnumSet.of(Role.NONE);
        if (field != null && !field.getValues().isEmpty()) {
            String value;
            switch (value = (String)field.getValues().get(0)) {
                case "anyone": {
                    roles = EnumSet.of(Role.MODERATOR, Role.PARTICIPANT);
                    break;
                }
                case "participants": {
                    roles = EnumSet.of(Role.PARTICIPANT);
                    break;
                }
                case "moderators": {
                    roles = EnumSet.of(Role.MODERATOR);
                    break;
                }
                default: {
                    roles = EnumSet.of(Role.NONE);
                }
            }
        }
        return roles;
    }

    public void setAllowedRolesToSendPrivateMessages(Set<Role> roles) {
        String value = roles.contains((Object)Role.MODERATOR) && roles.contains((Object)Role.PARTICIPANT) ? "anyone" : (roles.contains((Object)Role.PARTICIPANT) ? "participants" : (roles.contains((Object)Role.MODERATOR) ? "moderators" : "none"));
        DataForm.Field field = this.dataForm.findField(ALLOW_PM);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.LIST_SINGLE, ALLOW_PM, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(value);
    }

    public boolean isAllowInvites() {
        DataForm.Field field = this.dataForm.findField(ALLOW_INVITES);
        return field != null && !field.getValues().isEmpty() && DataForm.parseBoolean((String)((String)field.getValues().get(0)));
    }

    public void setAllowInvites(boolean allowInvites) {
        DataForm.Field field = this.dataForm.findField(ALLOW_INVITES);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.BOOLEAN, ALLOW_INVITES, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(allowInvites ? "1" : "0");
    }

    public boolean isChangeSubjectAllowed() {
        DataForm.Field field = this.dataForm.findField(CHANGE_SUBJECT);
        return field != null && !field.getValues().isEmpty() && DataForm.parseBoolean((String)((String)field.getValues().get(0)));
    }

    public void setChangeSubjectAllowed(boolean changeSubjectAllowed) {
        DataForm.Field field = this.dataForm.findField(CHANGE_SUBJECT);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.BOOLEAN, CHANGE_SUBJECT, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(changeSubjectAllowed ? "1" : "0");
    }

    public boolean isPublicLoggingEnabled() {
        DataForm.Field field = this.dataForm.findField(ENABLE_LOGGING);
        return field != null && !field.getValues().isEmpty() && DataForm.parseBoolean((String)((String)field.getValues().get(0)));
    }

    public void setPublicLoggingEnabled(boolean publicLoggingEnabled) {
        DataForm.Field field = this.dataForm.findField(ENABLE_LOGGING);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.BOOLEAN, ENABLE_LOGGING, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(publicLoggingEnabled ? "1" : "0");
    }

    public Set<Role> getRolesWhichMayRetrieveMemberList() {
        DataForm.Field field = this.dataForm.findField(GET_MEMBER_LIST);
        HashSet<Role> roles = new HashSet<Role>();
        if (field != null) {
            for (String value : field.getValues()) {
                switch (value.toLowerCase()) {
                    case "moderator": {
                        roles.add(Role.MODERATOR);
                        break;
                    }
                    case "participant": {
                        roles.add(Role.PARTICIPANT);
                        break;
                    }
                    case "visitor": {
                        roles.add(Role.VISITOR);
                        break;
                    }
                    case "none": {
                        roles.add(Role.NONE);
                    }
                }
            }
        }
        return roles;
    }

    public void setRolesWhichMayRetrieveMemberList(Set<Role> roles) {
        DataForm.Field field = this.dataForm.findField(GET_MEMBER_LIST);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.LIST_MULTI, GET_MEMBER_LIST, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        for (Role role : roles) {
            field.getValues().add(role.name().toLowerCase());
        }
    }

    public String getLanguage() {
        DataForm.Field field = this.dataForm.findField(LANGUAGE);
        if (field != null && !field.getValues().isEmpty()) {
            return (String)field.getValues().get(0);
        }
        return null;
    }

    public void setLanguage(String language) {
        DataForm.Field field = this.dataForm.findField(LANGUAGE);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, LANGUAGE, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(language);
    }

    public URI getPubSubNode() {
        DataForm.Field field = this.dataForm.findField(PUBSUB);
        if (field != null && !field.getValues().isEmpty()) {
            try {
                return URI.create((String)field.getValues().get(0));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public void setPubSubNode(URI pubSubNode) {
        DataForm.Field field = this.dataForm.findField(PUBSUB);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, PUBSUB, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(pubSubNode.toString());
    }

    public int getMaxOccupants() {
        return this.getAsInteger(MAX_USERS);
    }

    public void setMaxOccupants(int maxOccupants) {
        DataForm.Field field = this.dataForm.findField(MAX_USERS);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, MAX_USERS, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(Integer.toString(maxOccupants));
    }

    public boolean isMembersOnly() {
        DataForm.Field field = this.dataForm.findField(MEMBERS_ONLY);
        return field != null && !field.getValues().isEmpty() && DataForm.parseBoolean((String)((String)field.getValues().get(0)));
    }

    public void setMembersOnly(boolean membersOnly) {
        DataForm.Field field = this.dataForm.findField(MEMBERS_ONLY);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.BOOLEAN, MEMBERS_ONLY, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(membersOnly ? "1" : "0");
    }

    public boolean isModerated() {
        DataForm.Field field = this.dataForm.findField(MODERATED_ROOM);
        return field != null && !field.getValues().isEmpty() && DataForm.parseBoolean((String)((String)field.getValues().get(0)));
    }

    public void setModerated(boolean moderated) {
        DataForm.Field field = this.dataForm.findField(MODERATED_ROOM);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.BOOLEAN, MODERATED_ROOM, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(moderated ? "1" : "0");
    }

    public boolean isPasswordProtected() {
        DataForm.Field field = this.dataForm.findField(PASSWORD_PROTECTED);
        return field != null && !field.getValues().isEmpty() && DataForm.parseBoolean((String)((String)field.getValues().get(0)));
    }

    public void setPasswordProtected(boolean passwordProtected) {
        DataForm.Field field = this.dataForm.findField(PASSWORD_PROTECTED);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.BOOLEAN, PASSWORD_PROTECTED, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(passwordProtected ? "1" : "0");
    }

    public boolean isPersistentRoom() {
        DataForm.Field field = this.dataForm.findField(PERSISTENT_ROOM);
        return field != null && !field.getValues().isEmpty() && DataForm.parseBoolean((String)((String)field.getValues().get(0)));
    }

    public void setPersistentRoom(boolean persistentRoom) {
        DataForm.Field field = this.dataForm.findField(PERSISTENT_ROOM);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.BOOLEAN, PERSISTENT_ROOM, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(persistentRoom ? "1" : "0");
    }

    public Set<Role> getRolesForWhichPresenceIsBroadcast() {
        DataForm.Field field = this.dataForm.findField(PRESENCE_BROADCAST);
        HashSet<Role> roles = new HashSet<Role>();
        if (field != null) {
            for (String value : field.getValues()) {
                switch (value.toLowerCase()) {
                    case "moderator": {
                        roles.add(Role.MODERATOR);
                        break;
                    }
                    case "participant": {
                        roles.add(Role.PARTICIPANT);
                        break;
                    }
                    case "visitor": {
                        roles.add(Role.VISITOR);
                        break;
                    }
                    case "none": {
                        roles.add(Role.NONE);
                    }
                }
            }
        }
        return roles;
    }

    public void setRolesForWhichPresenceIsBroadcast(Set<Role> roles) {
        DataForm.Field field = this.dataForm.findField(PRESENCE_BROADCAST);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.LIST_MULTI, PRESENCE_BROADCAST, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        for (Role role : roles) {
            field.getValues().add(role.name().toLowerCase());
        }
    }

    public boolean isPublicRoom() {
        DataForm.Field field = this.dataForm.findField(PUBLIC_ROOM);
        return field != null && !field.getValues().isEmpty() && DataForm.parseBoolean((String)((String)field.getValues().get(0)));
    }

    public void setPublicRoom(boolean publicRoom) {
        DataForm.Field field = this.dataForm.findField(PUBLIC_ROOM);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.BOOLEAN, PUBLIC_ROOM, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(publicRoom ? "1" : "0");
    }

    public List<Jid> getAdministrators() {
        DataForm.Field field = this.dataForm.findField(ROOM_ADMINS);
        ArrayList<Jid> admins = new ArrayList<Jid>();
        if (field != null) {
            for (String value : field.getValues()) {
                admins.add(Jid.valueOf((String)value, (boolean)true));
            }
        }
        return admins;
    }

    public void setAdministrators(List<Jid> administrators) {
        DataForm.Field field = this.dataForm.findField(ROOM_ADMINS);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.JID_MULTI, ROOM_ADMINS, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        for (Jid admin : administrators) {
            field.getValues().add(admin.toString());
        }
    }

    public String getRoomDescription() {
        DataForm.Field field = this.dataForm.findField(ROOM_DESC);
        if (field != null && !field.getValues().isEmpty()) {
            return (String)field.getValues().get(0);
        }
        return null;
    }

    public void setRoomDescription(String description) {
        DataForm.Field field = this.dataForm.findField(ROOM_DESC);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, ROOM_DESC, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(description);
    }

    public String getRoomName() {
        DataForm.Field field = this.dataForm.findField(ROOM_NAME);
        if (field != null && !field.getValues().isEmpty()) {
            return (String)field.getValues().get(0);
        }
        return null;
    }

    public void setRoomName(String description) {
        DataForm.Field field = this.dataForm.findField(ROOM_NAME);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, ROOM_NAME, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(description);
    }

    public List<Jid> getOwners() {
        DataForm.Field field = this.dataForm.findField(ROOM_OWNERS);
        ArrayList<Jid> owners = new ArrayList<Jid>();
        if (field != null) {
            for (String value : field.getValues()) {
                owners.add(Jid.valueOf((String)value, (boolean)true));
            }
        }
        return owners;
    }

    public void setOwners(List<Jid> owners) {
        DataForm.Field field = this.dataForm.findField(ROOM_OWNERS);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.JID_MULTI, ROOM_OWNERS, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        for (Jid admin : owners) {
            field.getValues().add(admin.toString());
        }
    }

    public String getPassword() {
        DataForm.Field field = this.dataForm.findField(ROOM_SECRET);
        if (field != null && !field.getValues().isEmpty()) {
            return (String)field.getValues().get(0);
        }
        return null;
    }

    public void setPassword(String password) {
        DataForm.Field field = this.dataForm.findField(ROOM_SECRET);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, ROOM_SECRET, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(password);
    }

    public Set<Role> getRolesWhichMayDiscoverRealJids() {
        DataForm.Field field = this.dataForm.findField(WHOIS);
        EnumSet<Role> roles = EnumSet.of(Role.NONE);
        if (field != null && !field.getValues().isEmpty()) {
            String value;
            switch (value = (String)field.getValues().get(0)) {
                case "anyone": {
                    roles = EnumSet.of(Role.MODERATOR, Role.PARTICIPANT);
                    break;
                }
                case "participants": {
                    roles = EnumSet.of(Role.PARTICIPANT);
                    break;
                }
                case "moderators": {
                    roles = EnumSet.of(Role.MODERATOR);
                    break;
                }
                default: {
                    roles = EnumSet.of(Role.NONE);
                }
            }
        }
        return roles;
    }

    public void setRolesWhichMayDiscoverRealJids(Set<Role> roles) {
        String value = roles.contains((Object)Role.MODERATOR) && roles.contains((Object)Role.PARTICIPANT) ? "anyone" : (roles.contains((Object)Role.PARTICIPANT) ? "participants" : (roles.contains((Object)Role.MODERATOR) ? "moderators" : "none"));
        DataForm.Field field = this.dataForm.findField(WHOIS);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.LIST_SINGLE, WHOIS, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(value);
    }
}

