/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.data.model.DataForm;

public final class RoomInfoForm {
    private static final String MAX_HISTORY_FETCH = "muc#maxhistoryfetch";
    private static final String CONTACT_JID = "muc#roominfo_contactjid";
    private static final String DESCRIPTION = "muc#roominfo_description";
    private static final String LANGUAGE = "muc#roominfo_lang";
    private static final String LDAP_GROUP = "muc#roominfo_ldapgroup";
    private static final String LOGS = "muc#roominfo_logs";
    private static final String OCCUPANTS = "muc#roominfo_occupants";
    private static final String SUBJECT = "muc#roominfo_subject";
    private static final String SUBJECT_MOD = "muc#roominfo_subjectmod";
    private final DataForm dataForm;

    public RoomInfoForm(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public int getMaxHistoryMessages() {
        return this.getAsInteger(MAX_HISTORY_FETCH);
    }

    public void setMaxHistoryMessages(int maxHistoryMessages) {
        DataForm.Field field = this.getOrCreateField(DataForm.Field.Type.TEXT_SINGLE, MAX_HISTORY_FETCH);
        field.getValues().clear();
        field.getValues().add(Integer.toString(maxHistoryMessages));
    }

    public List<Jid> getContacts() {
        DataForm.Field field = this.dataForm.findField(CONTACT_JID);
        ArrayList<Jid> admins = new ArrayList<Jid>();
        if (field != null) {
            for (String value : field.getValues()) {
                admins.add(Jid.valueOf((String)value, (boolean)true));
            }
        }
        return admins;
    }

    public void setContacts(List<Jid> administrators) {
        DataForm.Field field = this.dataForm.findField(CONTACT_JID);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.JID_MULTI, CONTACT_JID, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        for (Jid admin : administrators) {
            field.getValues().add(admin.toString());
        }
    }

    public String getDescription() {
        DataForm.Field field = this.dataForm.findField(DESCRIPTION);
        if (field != null && !field.getValues().isEmpty()) {
            return (String)field.getValues().get(0);
        }
        return null;
    }

    public void setDescription(String description) {
        DataForm.Field field = this.dataForm.findField(DESCRIPTION);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, DESCRIPTION, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(description);
    }

    public String getLanguage() {
        DataForm.Field field = this.dataForm.findField(LANGUAGE);
        if (field != null && !field.getValues().isEmpty()) {
            return (String)field.getValues().get(0);
        }
        return null;
    }

    public void setLanguage(String language) {
        DataForm.Field field = this.dataForm.findField(LANGUAGE);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, LANGUAGE, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(language);
    }

    public String getLdapGroup() {
        DataForm.Field field = this.dataForm.findField(LDAP_GROUP);
        if (field != null && !field.getValues().isEmpty()) {
            return (String)field.getValues().get(0);
        }
        return null;
    }

    public void setLdapGroup(String ldapGroup) {
        DataForm.Field field = this.dataForm.findField(LDAP_GROUP);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, LDAP_GROUP, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(ldapGroup);
    }

    public URL getLogs() {
        DataForm.Field field = this.dataForm.findField(LOGS);
        if (field != null && !field.getValues().isEmpty()) {
            try {
                return new URL((String)field.getValues().get(0));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public void setLogs(URL logs) {
        DataForm.Field field = this.dataForm.findField(LOGS);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, LOGS, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(logs.toString());
    }

    public int getCurrentNumberOfOccupants() {
        return this.getAsInteger(OCCUPANTS);
    }

    public void setCurrentNumberOfOccupants(int currentNumberOfOccupants) {
        DataForm.Field field = this.getOrCreateField(DataForm.Field.Type.TEXT_SINGLE, OCCUPANTS);
        field.getValues().clear();
        field.getValues().add(Integer.toString(currentNumberOfOccupants));
    }

    public String getSubject() {
        DataForm.Field field = this.dataForm.findField(SUBJECT);
        if (field != null && !field.getValues().isEmpty()) {
            return (String)field.getValues().get(0);
        }
        return null;
    }

    public void setSubject(String subject) {
        DataForm.Field field = this.dataForm.findField(SUBJECT);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.TEXT_SINGLE, SUBJECT, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(subject);
    }

    public boolean isChangeSubjectAllowed() {
        DataForm.Field field = this.dataForm.findField(SUBJECT_MOD);
        return field != null && !field.getValues().isEmpty() && DataForm.parseBoolean((String)((String)field.getValues().get(0)));
    }

    public void setChangeSubjectAllowed(boolean changeSubjectAllowed) {
        DataForm.Field field = this.dataForm.findField(SUBJECT_MOD);
        if (field == null) {
            field = new DataForm.Field(DataForm.Field.Type.BOOLEAN, SUBJECT_MOD, new String[0]);
            this.dataForm.getFields().add(field);
        }
        field.getValues().clear();
        field.getValues().add(changeSubjectAllowed ? "1" : "0");
    }

    private DataForm.Field getOrCreateField(DataForm.Field.Type type, String var) {
        DataForm.Field field = this.dataForm.findField(var);
        if (field == null) {
            field = new DataForm.Field(type, var, new String[0]);
            this.dataForm.getFields().add(field);
        }
        return field;
    }

    private int getAsInteger(String fieldName) {
        DataForm.Field field = this.dataForm.findField(fieldName);
        if (field != null && !field.getValues().isEmpty()) {
            try {
                return Integer.parseInt((String)field.getValues().get(0));
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }
}

