/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privacy.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.privacy.model.PrivacyRule;

public final class PrivacyList
implements Comparable<PrivacyList> {
    @XmlElement(name="item")
    private final List<PrivacyRule> items = new ArrayList<PrivacyRule>();
    @XmlTransient
    public boolean isActive;
    @XmlTransient
    public boolean isDefault;
    @XmlAttribute(name="name")
    private String name;

    private PrivacyList() {
    }

    public PrivacyList(String name) {
        this.name = name;
    }

    public static PrivacyList createInvisibilityList() {
        return PrivacyList.createInvisibilityListExceptForUsers("invisible", new Jid[0]);
    }

    public static PrivacyList createInvisibilityListExceptForUsers(String listName, Jid ... jids) {
        PrivacyList privacyList = new PrivacyList(listName);
        long order = 1L;
        for (Jid jid : jids) {
            PrivacyRule privacyRule = new PrivacyRule(PrivacyRule.Action.ALLOW, order++, jid);
            privacyRule.setFilterPresenceOut(true);
            privacyList.getPrivacyRules().add(privacyRule);
        }
        PrivacyRule privacyRule = new PrivacyRule(PrivacyRule.Action.DENY, order);
        privacyRule.setFilterPresenceOut(true);
        privacyList.getPrivacyRules().add(privacyRule);
        return privacyList;
    }

    public static PrivacyList createInvisibilityListExceptForGroups(String listName, String ... groups) {
        PrivacyList privacyList = new PrivacyList(listName);
        long order = 1L;
        for (String group : groups) {
            PrivacyRule privacyRule = new PrivacyRule(PrivacyRule.Action.ALLOW, order++, group);
            privacyRule.setFilterPresenceOut(true);
            privacyList.getPrivacyRules().add(privacyRule);
        }
        PrivacyRule privacyRule = new PrivacyRule(PrivacyRule.Action.DENY, order);
        privacyRule.setFilterPresenceOut(true);
        privacyList.getPrivacyRules().add(privacyRule);
        return privacyList;
    }

    public static PrivacyList createInvisibilityListForUsers(String listName, Jid ... jids) {
        PrivacyList privacyList = new PrivacyList(listName);
        long order = 1L;
        for (Jid jid : jids) {
            PrivacyRule privacyRule = new PrivacyRule(PrivacyRule.Action.DENY, order++, jid);
            privacyRule.setFilterPresenceOut(true);
            privacyList.getPrivacyRules().add(privacyRule);
        }
        PrivacyRule privacyRule = new PrivacyRule(PrivacyRule.Action.ALLOW, order);
        privacyRule.setFilterPresenceOut(true);
        privacyList.getPrivacyRules().add(privacyRule);
        return privacyList;
    }

    public static PrivacyList createInvisibilityListForGroups(String listName, String ... groups) {
        PrivacyList privacyList = new PrivacyList(listName);
        long order = 1L;
        for (String group : groups) {
            PrivacyRule privacyRule = new PrivacyRule(PrivacyRule.Action.DENY, order++, group);
            privacyRule.setFilterPresenceOut(true);
            privacyList.getPrivacyRules().add(privacyRule);
        }
        PrivacyRule privacyRule = new PrivacyRule(PrivacyRule.Action.ALLOW, order);
        privacyRule.setFilterPresenceOut(true);
        privacyList.getPrivacyRules().add(privacyRule);
        return privacyList;
    }

    public List<PrivacyRule> getPrivacyRules() {
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public int compareTo(PrivacyList o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            if (this.isDefault) {
                if (o.isDefault) {
                    return this.name != null ? this.name.compareTo(o.name) : 1;
                }
                return -1;
            }
            if (this.isActive) {
                if (o.isDefault) {
                    return 1;
                }
                if (o.isActive) {
                    return this.name != null ? this.name.compareTo(o.name) : 1;
                }
                return -1;
            }
            if (o.isDefault || o.isActive) {
                return 1;
            }
            return this.name != null ? this.name.compareTo(o.name) : 1;
        }
        return -1;
    }

    public String toString() {
        return this.name;
    }
}

