/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privacy.model;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.roster.model.Contact;

public final class PrivacyRule
implements Comparable<PrivacyRule> {
    @XmlAttribute(name="type")
    private Type type;
    @XmlAttribute(name="value")
    private String value;
    @XmlAttribute(name="action")
    private Action action;
    @XmlAttribute(name="order")
    private long order;
    @XmlElement(name="iq")
    private String iq;
    @XmlElement(name="message")
    private String message;
    @XmlElement(name="presence-in")
    private String presenceIn;
    @XmlElement(name="presence-out")
    private String presenceOut;

    public PrivacyRule(Action action, long order) {
        this(action, order, null, null);
    }

    private PrivacyRule(Action action, long order, Type type, String value) {
        if (action == null) {
            throw new IllegalArgumentException("action must not be null.");
        }
        if (order < 0L) {
            throw new IllegalArgumentException("order must be greater 0.");
        }
        this.action = action;
        this.order = order;
        this.type = type;
        this.value = value;
    }

    private PrivacyRule() {
    }

    public PrivacyRule(Action action, long order, Contact.Subscription subscription) {
        if (Contact.Subscription.REMOVE.equals((Object)subscription)) {
            throw new IllegalArgumentException("subscription must not be 'remove'");
        }
        this.action = action;
        this.order = order;
        this.type = Type.SUBSCRIPTION;
        this.value = subscription.name().toLowerCase();
    }

    public PrivacyRule(Action action, long order, Jid jid) {
        this(action, order, Type.JID, jid.toEscapedString());
    }

    public PrivacyRule(Action action, long order, String group) {
        this(action, order, Type.GROUP, group);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public long getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isFilterMessage() {
        return this.message != null || this.isFilterEverything();
    }

    public void setFilterMessage(boolean filterMessages) {
        this.message = filterMessages ? "" : null;
    }

    public boolean isFilterIQ() {
        return this.iq != null || this.isFilterEverything();
    }

    public void setFilterIQ(boolean filterIQ) {
        this.iq = filterIQ ? "" : null;
    }

    public boolean isFilterPresenceIn() {
        return this.presenceIn != null || this.isFilterEverything();
    }

    public void setFilterPresenceIn(boolean filterPresenceIn) {
        this.presenceIn = filterPresenceIn ? "" : null;
    }

    public boolean isFilterPresenceOut() {
        return this.presenceOut != null || this.isFilterEverything();
    }

    public void setFilterPresenceOut(boolean filterPresenceOut) {
        this.presenceOut = filterPresenceOut ? "" : null;
    }

    private boolean isFilterEverything() {
        return this.presenceIn == null && this.presenceOut == null && this.message == null && this.iq == null;
    }

    @Override
    public int compareTo(PrivacyRule o) {
        if (this == o) {
            return 0;
        }
        return o != null ? Long.compare(this.order, o.order) : -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.action.name().toLowerCase());
        sb.append(", ");
        sb.append(this.order);
        if (this.type != null) {
            sb.append(", ");
            sb.append(this.type.name().toLowerCase());
        }
        if (this.value != null) {
            sb.append(", ");
            sb.append(this.value);
        }
        return sb.toString();
    }

    public static enum Action {
        ALLOW,
        DENY;

    }

    public static enum Type {
        GROUP,
        JID,
        SUBSCRIPTION;

    }
}

