/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privatedata.rosternotes.model;

import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.JidAdapter;

@XmlRootElement(name="storage")
public final class Annotation {
    @XmlElement(name="note")
    private List<Note> notes;

    private Annotation() {
    }

    public Annotation(List<Note> notes) {
        this.notes = notes;
    }

    public List<Note> getNotes() {
        return this.notes;
    }

    public static final class Note {
        @XmlJavaTypeAdapter(value=JidAdapter.class)
        @XmlAttribute(name="jid")
        private Jid jid;
        @XmlAttribute(name="cdate")
        private Date creationDate;
        @XmlAttribute(name="mdate")
        private Date modificationDate;
        @XmlValue
        private String value;

        private Note() {
        }

        public Note(String note, Jid jid) {
            this(note, jid, null, null);
        }

        public Note(String note, Jid jid, Date creationDate, Date modificationDate) {
            if (jid == null) {
                throw new IllegalArgumentException("jid must not be null.");
            }
            this.value = note;
            this.jid = jid.asBareJid();
            this.creationDate = creationDate;
            this.modificationDate = modificationDate;
        }

        public String getValue() {
            return this.value;
        }

        public Date getModificationDate() {
            return this.modificationDate;
        }

        public Date getCreationDate() {
            return this.creationDate;
        }

        public Jid getJid() {
            return this.jid;
        }

        public String toString() {
            return this.value;
        }
    }
}

