/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.pubsub.model.Affiliation;
import rocks.xmpp.extensions.pubsub.model.AffiliationState;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.SubscriptionState;
import rocks.xmpp.extensions.pubsub.model.errors.ClosedNode;
import rocks.xmpp.extensions.pubsub.model.errors.ConfigurationRequired;
import rocks.xmpp.extensions.pubsub.model.errors.InvalidJid;
import rocks.xmpp.extensions.pubsub.model.errors.InvalidOptions;
import rocks.xmpp.extensions.pubsub.model.errors.InvalidPayload;
import rocks.xmpp.extensions.pubsub.model.errors.InvalidSubId;
import rocks.xmpp.extensions.pubsub.model.errors.ItemForbidden;
import rocks.xmpp.extensions.pubsub.model.errors.ItemRequired;
import rocks.xmpp.extensions.pubsub.model.errors.JidRequired;
import rocks.xmpp.extensions.pubsub.model.errors.MaxItemsExceeded;
import rocks.xmpp.extensions.pubsub.model.errors.MaxNodesExceeded;
import rocks.xmpp.extensions.pubsub.model.errors.NodeIdRequired;
import rocks.xmpp.extensions.pubsub.model.errors.NotInRosterGroup;
import rocks.xmpp.extensions.pubsub.model.errors.NotSubscribed;
import rocks.xmpp.extensions.pubsub.model.errors.PayloadRequired;
import rocks.xmpp.extensions.pubsub.model.errors.PayloadTooBig;
import rocks.xmpp.extensions.pubsub.model.errors.PendingSubscription;
import rocks.xmpp.extensions.pubsub.model.errors.PresenceSubscriptionRequired;
import rocks.xmpp.extensions.pubsub.model.errors.SubIdRequired;
import rocks.xmpp.extensions.pubsub.model.errors.TooManySubscriptions;
import rocks.xmpp.extensions.pubsub.model.errors.Unsupported;
import rocks.xmpp.extensions.pubsub.model.event.Event;
import rocks.xmpp.extensions.pubsub.model.owner.PubSubOwner;

@XmlRootElement(name="pubsub")
@XmlSeeAlso(value={Unsupported.class, InvalidJid.class, PresenceSubscriptionRequired.class, NotInRosterGroup.class, ClosedNode.class, PendingSubscription.class, TooManySubscriptions.class, ConfigurationRequired.class, SubIdRequired.class, NotSubscribed.class, NotSubscribed.class, InvalidSubId.class, JidRequired.class, InvalidOptions.class, PayloadTooBig.class, InvalidPayload.class, ItemRequired.class, PayloadRequired.class, ItemForbidden.class, NodeIdRequired.class, MaxItemsExceeded.class, MaxNodesExceeded.class, Event.class, PubSubOwner.class})
public final class PubSub {
    public static final String NAMESPACE = "http://jabber.org/protocol/pubsub";
    @XmlElement(name="create")
    private Create create;
    @XmlElement(name="configure")
    private Configure configure;
    @XmlElement(name="subscribe")
    private Subscribe subscribe;
    @XmlElement(name="options")
    private Options options;
    @XmlElements(value={@XmlElement(name="affiliations", type=AffiliationsElement.class), @XmlElement(name="default", type=Default.class), @XmlElement(name="items", type=Items.class), @XmlElement(name="publish", type=Publish.class), @XmlElement(name="retract", type=Retract.class), @XmlElement(name="subscription", type=SubscriptionInfo.class), @XmlElement(name="subscriptions", type=Subscriptions.class), @XmlElement(name="unsubscribe", type=Unsubscribe.class)})
    private PubSubChildElement type;

    private PubSub() {
    }

    private PubSub(Create create, Configure configure) {
        this.create = create;
        this.configure = configure;
    }

    private PubSub(Subscribe subscribe, Options options) {
        this.subscribe = subscribe;
        this.options = options;
    }

    private PubSub(Options options) {
        this.options = options;
    }

    private PubSub(PubSubChildElement pubSubChildElement) {
        this.type = pubSubChildElement;
    }

    private PubSub(Configure configure) {
        this.configure = configure;
    }

    private PubSub(Subscribe subscribe) {
        this.subscribe = subscribe;
    }

    public static PubSub withAffiliations() {
        return PubSub.withAffiliations(null);
    }

    public static PubSub withAffiliations(String node) {
        return new PubSub(new AffiliationsElement(node));
    }

    public static PubSub withConfigure(String node, DataForm configurationForm) {
        return new PubSub(new Configure(node, configurationForm));
    }

    public static PubSub withCreate(String node) {
        return new PubSub(new Create(node), null);
    }

    public static PubSub withCreate(String node, DataForm configurationForm) {
        return new PubSub(new Create(node), new Configure(configurationForm));
    }

    public static PubSub withSubscriptions() {
        return PubSub.withSubscriptions(null);
    }

    public static PubSub withSubscriptions(String node) {
        return new PubSub(new Subscriptions(node));
    }

    public static PubSub withSubscribe(String node, Jid jid) {
        return new PubSub(new Subscribe(node, jid));
    }

    public static PubSub withSubscribe(String node, Jid jid, DataForm dataForm) {
        return new PubSub(new Subscribe(node, jid), new Options(dataForm));
    }

    public static PubSub withOptions(String node, Jid jid) {
        return new PubSub(new Options(node, jid));
    }

    public static PubSub withUnsubscribe(String node, Jid jid, String subscriptionId) {
        return new PubSub(new Unsubscribe(node, jid, subscriptionId));
    }

    public static PubSub withDefault() {
        return PubSub.withDefault(null);
    }

    public static PubSub withDefault(String node) {
        return new PubSub(new Default(node));
    }

    public static PubSub withItems(String node) {
        return new PubSub(new Items(node));
    }

    public static PubSub withItems(String node, String ... ids) {
        ArrayList<ItemElement> items = new ArrayList<ItemElement>();
        for (String id : ids) {
            items.add(new ItemElement(id));
        }
        return new PubSub(new Items(node, items));
    }

    public static PubSub withItems(String node, int maxItems) {
        return new PubSub(new Items(node, maxItems));
    }

    public static PubSub withPublish(String node, String id, Object item) {
        return new PubSub(new Publish(node, new ItemElement(id, item)));
    }

    public static PubSub withRetract(String node, String id, boolean notify) {
        return new PubSub(new Retract(node, new ItemElement(id), notify));
    }

    public Default getDefault() {
        if (this.type instanceof Default) {
            return (Default)this.type;
        }
        return null;
    }

    public Subscription getSubscription() {
        if (this.type instanceof SubscriptionInfo) {
            return (SubscriptionInfo)this.type;
        }
        return null;
    }

    public Options getOptions() {
        return this.options;
    }

    public List<Item> getItems() {
        if (this.type instanceof Items) {
            return Collections.unmodifiableList(new ArrayList(((Items)this.type).getItems()));
        }
        return null;
    }

    public Publish getPublish() {
        if (this.type instanceof Publish) {
            return (Publish)this.type;
        }
        return null;
    }

    public DataForm getConfigurationForm() {
        if (this.configure != null) {
            return this.configure.getConfigurationForm();
        }
        return null;
    }

    public List<Subscription> getSubscriptions() {
        if (this.type instanceof Subscriptions) {
            return Collections.unmodifiableList(new ArrayList(((Subscriptions)this.type).getSubscriptions()));
        }
        return null;
    }

    public List<Affiliation> getAffiliations() {
        if (this.type instanceof AffiliationsElement) {
            return Collections.unmodifiableList(new ArrayList(((AffiliationsElement)this.type).getAffiliations()));
        }
        return null;
    }

    public String getNode() {
        if (this.type != null) {
            return this.type.getNode();
        }
        if (this.create != null) {
            return this.create.getNode();
        }
        if (this.subscribe != null) {
            return this.subscribe.getNode();
        }
        return null;
    }

    private static abstract class PubSubChildElement {
        @XmlAttribute(name="node")
        private String node;

        private PubSubChildElement() {
        }

        private PubSubChildElement(String node) {
            this.node = node;
        }

        public String getNode() {
            return this.node;
        }
    }

    public static final class ItemElement
    implements Item {
        @XmlAnyElement(lax=true)
        private Object object;
        @XmlAttribute(name="id")
        private String id;

        private ItemElement() {
        }

        public ItemElement(String id) {
            this.id = id;
        }

        private ItemElement(String id, Object object) {
            this.id = id;
            this.object = object;
        }

        @Override
        public Object getPayload() {
            return this.object;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getNode() {
            return null;
        }

        @Override
        public String getPublisher() {
            return null;
        }
    }

    private static final class Configure {
        @XmlAttribute(name="node")
        private String node;
        @XmlElementRef
        private DataForm dataForm;

        private Configure() {
        }

        private Configure(String node, DataForm dataForm) {
            this.node = node;
            this.dataForm = dataForm;
        }

        private Configure(DataForm dataForm) {
            this.dataForm = dataForm;
        }

        private DataForm getConfigurationForm() {
            return this.dataForm;
        }
    }

    private static final class Unsubscribe
    extends PubSubChildElement {
        @XmlAttribute(name="node")
        private String node;
        @XmlAttribute(name="jid")
        private Jid jid;
        @XmlAttribute(name="subid")
        private String subid;

        private Unsubscribe() {
        }

        private Unsubscribe(String node, Jid jid, String subid) {
            super(node);
            this.jid = jid;
            this.subid = subid;
        }
    }

    private static final class Subscriptions
    extends PubSubChildElement {
        @XmlElement(name="subscription")
        private final List<SubscriptionInfo> subscriptions = new ArrayList<SubscriptionInfo>();

        private Subscriptions() {
        }

        private Subscriptions(String node) {
            super(node);
        }

        private List<? extends Subscription> getSubscriptions() {
            return this.subscriptions;
        }
    }

    private static final class SubscriptionInfo
    extends PubSubChildElement
    implements Subscription {
        @XmlAttribute(name="jid")
        private Jid jid;
        @XmlAttribute(name="subid")
        private String subid;
        @XmlAttribute(name="subscription")
        private SubscriptionState type;
        @XmlAttribute(name="expiry")
        private Date expiry;
        @XmlElement(name="subscribe-options")
        private SubscribeOptions options;

        private SubscriptionInfo() {
        }

        @Override
        public String getSubId() {
            return this.subid;
        }

        @Override
        public SubscriptionState getSubscriptionState() {
            return this.type;
        }

        @Override
        public Jid getJid() {
            return this.jid;
        }

        @Override
        public Date getExpiry() {
            return this.expiry;
        }

        @Override
        public boolean isConfigurationRequired() {
            return this.options != null && this.options.isRequired();
        }

        @Override
        public boolean isConfigurationSupported() {
            return this.options != null;
        }

        private static final class SubscribeOptions {
            @XmlElement(name="required")
            private String required;

            private SubscribeOptions() {
            }

            private boolean isRequired() {
                return this.required != null;
            }
        }
    }

    private static final class Retract
    extends PubSubChildElement {
        @XmlAttribute(name="notify")
        private Boolean notify;
        @XmlElement
        private ItemElement item;
        @XmlAttribute
        private String id;

        private Retract() {
        }

        private Retract(String node, ItemElement item, Boolean notify) {
            super(node);
            this.item = item;
            this.notify = notify;
        }

        private String getId() {
            return this.id;
        }
    }

    public static final class Publish
    extends PubSubChildElement {
        @XmlElement(name="item")
        private ItemElement item;

        private Publish() {
        }

        private Publish(String node, ItemElement item) {
            super(node);
            this.item = item;
        }

        public Item getItem() {
            return this.item;
        }
    }

    private static final class Items
    extends PubSubChildElement {
        @XmlElement(name="item")
        private final List<ItemElement> items = new ArrayList<ItemElement>();
        @XmlAttribute(name="max_items")
        private Integer maxItems;
        @XmlAttribute(name="subid")
        private String subid;
        @XmlElement(name="retract")
        private Retract retract;

        private Items() {
        }

        private Items(String node) {
            super(node);
        }

        private Items(String node, int maxItems) {
            super(node);
            this.maxItems = maxItems;
        }

        private Items(String node, List<ItemElement> items) {
            super(node);
            this.items.addAll(items);
        }

        private List<? extends Item> getItems() {
            return this.items;
        }
    }

    public static final class Default
    extends PubSubChildElement {
        @XmlAttribute(name="type")
        private Type type;
        @XmlElementRef
        private DataForm dataForm;

        public Default() {
        }

        private Default(String node) {
            super(node);
        }

        public DataForm getDataForm() {
            return this.dataForm;
        }

        private static enum Type {
            COLLECTION,
            LEAF;

        }
    }

    private static final class AffiliationsElement
    extends PubSubChildElement {
        @XmlElement(name="affiliation")
        private final List<AffiliationInfo> affiliations = new ArrayList<AffiliationInfo>();

        private AffiliationsElement() {
        }

        private AffiliationsElement(String node) {
            super(node);
        }

        private List<? extends Affiliation> getAffiliations() {
            return this.affiliations;
        }

        private static final class AffiliationInfo
        implements Affiliation {
            @XmlAttribute(name="node")
            private String node;
            @XmlAttribute(name="affiliation")
            private AffiliationState affiliation;
            @XmlAttribute(name="jid")
            private Jid jid;

            private AffiliationInfo() {
            }

            @Override
            public Jid getJid() {
                return this.jid;
            }

            @Override
            public AffiliationState getAffiliationState() {
                return this.affiliation;
            }

            @Override
            public String getNode() {
                return this.node;
            }
        }
    }

    public static final class Options {
        @XmlAttribute(name="node")
        private String node;
        @XmlAttribute(name="jid")
        private Jid jid;
        @XmlElementRef
        private DataForm dataForm;

        private Options() {
        }

        private Options(String node, Jid jid) {
            this.node = node;
            this.jid = jid;
        }

        private Options(DataForm dataForm) {
            this.dataForm = dataForm;
        }

        public DataForm getDataForm() {
            return this.dataForm;
        }
    }

    private static final class Subscribe
    extends PubSubChildElement {
        @XmlAttribute(name="jid")
        private Jid jid;

        private Subscribe() {
        }

        private Subscribe(String node, Jid jid) {
            super(node);
            this.jid = jid;
        }
    }

    private static final class Create
    extends PubSubChildElement {
        private Create() {
        }

        private Create(String node) {
            super(node);
        }
    }
}

