/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model.owner;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.pubsub.model.Affiliation;
import rocks.xmpp.extensions.pubsub.model.AffiliationState;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.SubscriptionState;

@XmlRootElement(name="pubsub")
public final class PubSubOwner {
    @XmlElements(value={@XmlElement(name="affiliations", type=Affiliations.class), @XmlElement(name="configure", type=Configure.class), @XmlElement(name="default", type=Default.class), @XmlElement(name="delete", type=Delete.class), @XmlElement(name="purge", type=Purge.class), @XmlElement(name="subscriptions", type=Subscriptions.class)})
    private PubSubOwnerChildElement type;

    private PubSubOwner() {
    }

    private PubSubOwner(PubSubOwnerChildElement type) {
        this.type = type;
    }

    public static PubSubOwner withConfigure(String node) {
        return new PubSubOwner(new Configure(node));
    }

    public static PubSubOwner withConfigure(String node, DataForm dataForm) {
        return new PubSubOwner(new Configure(node, dataForm));
    }

    public static PubSubOwner withDefault() {
        return new PubSubOwner(new Default());
    }

    public static PubSubOwner withDelete(String node) {
        return new PubSubOwner(new Delete(node));
    }

    public static PubSubOwner withDelete(String node, URI replacementNode) {
        return new PubSubOwner(new Delete(node, new Delete.Redirect(replacementNode)));
    }

    public static PubSubOwner withPurge(String node) {
        return new PubSubOwner(new Purge(node));
    }

    public static PubSubOwner withSubscriptions(String node) {
        return new PubSubOwner(new Subscriptions(node));
    }

    public static PubSubOwner withSubscriptions(String node, Subscription ... subscriptions) {
        return new PubSubOwner(new Subscriptions(node));
    }

    public static PubSubOwner withAffiliations(String node) {
        return new PubSubOwner(new Affiliations(node));
    }

    public static PubSubOwner withAffiliations(String node, Affiliation ... affiliationNodes) {
        return new PubSubOwner(new Affiliations(node));
    }

    public DataForm getConfigurationForm() {
        if (this.type instanceof Configure) {
            return ((Configure)this.type).getDataForm();
        }
        if (this.type instanceof Default) {
            return ((Default)this.type).getDataForm();
        }
        return null;
    }

    public String getNode() {
        return this.type != null ? this.type.getNode() : null;
    }

    public boolean isConfigure() {
        return this.type instanceof Configure;
    }

    public boolean isDefault() {
        return this.type instanceof Default;
    }

    public boolean isDelete() {
        return this.type instanceof Delete;
    }

    public boolean isPurge() {
        return this.type instanceof Purge;
    }

    public boolean isSubscriptions() {
        return this.type instanceof Subscriptions;
    }

    public List<? extends Subscription> getSubscriptions() {
        if (this.type instanceof Subscriptions) {
            return ((Subscriptions)this.type).getSubscriptions();
        }
        return null;
    }

    public List<? extends Affiliation> getAffiliations() {
        if (this.type instanceof Affiliations) {
            return ((Affiliations)this.type).getAffiliations();
        }
        return null;
    }

    public URI getRedirectUri() {
        if (this.type instanceof Delete && ((Delete)this.type).getRedirect() != null) {
            return ((Delete)this.type).getRedirect().getUri();
        }
        return null;
    }

    private static abstract class PubSubOwnerChildElement {
        @XmlAttribute(name="node")
        private String node;

        private PubSubOwnerChildElement() {
        }

        private PubSubOwnerChildElement(String node) {
            this.node = node;
        }

        private String getNode() {
            return this.node;
        }
    }

    private static final class Subscriptions
    extends PubSubOwnerChildElement {
        @XmlElement(name="subscription")
        private List<SubscriptionOwner> subscriptions;

        private Subscriptions() {
        }

        private Subscriptions(String node) {
            super(node);
        }

        private List<SubscriptionOwner> getSubscriptions() {
            return this.subscriptions;
        }

        private static final class SubscriptionOwner
        implements Subscription {
            @XmlAttribute(name="node")
            private String node;
            @XmlAttribute(name="jid")
            private Jid jid;
            @XmlAttribute(name="subid")
            private String subid;
            @XmlAttribute(name="subscription")
            private SubscriptionState status;
            @XmlAttribute(name="expiry")
            private Date expiry;
            @XmlElement(name="subscribe-options")
            private Options options;

            private SubscriptionOwner() {
            }

            @Override
            public SubscriptionState getSubscriptionState() {
                return this.status;
            }

            @Override
            public String getNode() {
                return this.node;
            }

            @Override
            public Jid getJid() {
                return this.jid;
            }

            @Override
            public String getSubId() {
                return this.subid;
            }

            @Override
            public Date getExpiry() {
                return this.expiry;
            }

            @Override
            public boolean isConfigurationRequired() {
                return this.options != null && this.options.isRequired();
            }

            @Override
            public boolean isConfigurationSupported() {
                return this.options != null;
            }

            private static final class Options {
                @XmlElement(name="required")
                private String required;

                private Options() {
                }

                private boolean isRequired() {
                    return this.required != null;
                }
            }
        }
    }

    private static final class Purge
    extends PubSubOwnerChildElement {
        private Purge() {
        }

        private Purge(String node) {
            super(node);
        }
    }

    private static final class Delete
    extends PubSubOwnerChildElement {
        @XmlElement(name="redirect")
        private Redirect redirect;

        private Delete() {
        }

        private Delete(String node) {
            super(node);
        }

        private Delete(String node, Redirect redirect) {
            super(node);
            this.redirect = redirect;
        }

        private Redirect getRedirect() {
            return this.redirect;
        }

        private static final class Redirect {
            @XmlAttribute(name="uri")
            private URI uri;

            private Redirect() {
            }

            private Redirect(URI uri) {
                this.uri = uri;
            }

            private URI getUri() {
                return this.uri;
            }
        }
    }

    private static final class Default
    extends PubSubOwnerChildElement {
        @XmlElementRef
        private DataForm dataForm;

        private Default() {
        }

        private DataForm getDataForm() {
            return this.dataForm;
        }
    }

    private static final class Configure
    extends PubSubOwnerChildElement {
        @XmlElementRef
        private DataForm dataForm;

        private Configure() {
        }

        private Configure(String node) {
            super(node);
        }

        private Configure(String node, DataForm dataForm) {
            super(node);
            this.dataForm = dataForm;
        }

        private Configure(DataForm dataForm) {
            this.dataForm = dataForm;
        }

        private DataForm getDataForm() {
            return this.dataForm;
        }
    }

    private static final class Affiliations
    extends PubSubOwnerChildElement {
        @XmlElement(name="affiliation")
        private final List<AffiliationNodeOwner> affiliations = new ArrayList<AffiliationNodeOwner>();

        private Affiliations() {
            super(null);
        }

        private Affiliations(String node) {
            super(node);
        }

        private List<? extends Affiliation> getAffiliations() {
            return this.affiliations;
        }

        private static final class AffiliationNodeOwner
        implements Affiliation {
            @XmlAttribute(name="node")
            private String node;
            @XmlAttribute(name="affiliation")
            private AffiliationState affiliation;
            @XmlAttribute(name="jid")
            private Jid jid;

            private AffiliationNodeOwner() {
            }

            @Override
            public Jid getJid() {
                return this.jid;
            }

            @Override
            public AffiliationState getAffiliationState() {
                return this.affiliation;
            }

            @Override
            public String getNode() {
                return this.node;
            }
        }
    }
}

