/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.si.profile.filetransfer.model;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.extensions.filetransfer.FileTransferOffer;
import rocks.xmpp.extensions.filetransfer.Range;
import rocks.xmpp.extensions.hashes.model.Hash;

@XmlRootElement(name="file")
public final class SIFileTransferOffer
implements FileTransferOffer {
    public static final String NAMESPACE = "http://jabber.org/protocol/si/profile/file-transfer";
    @XmlAttribute(name="size")
    private Long size;
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="date")
    private Date date;
    @XmlAttribute(name="hash")
    private String hash;
    @XmlElement(name="desc")
    private String description;
    @XmlElement(name="range")
    private SIRange range;

    private SIFileTransferOffer() {
    }

    public SIFileTransferOffer(String name, long size) {
        this.name = name;
        this.size = size;
    }

    public SIFileTransferOffer(String name, long size, Date lastModified, String hash, String description, SIRange range) {
        this.name = name;
        this.size = size;
        this.date = lastModified;
        this.hash = hash;
        this.description = description;
        this.range = range;
    }

    @Override
    public long getSize() {
        return this.size != null ? this.size : 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public List<Hash> getHashes() {
        if (this.hash != null) {
            return Arrays.asList(new Hash(new BigInteger(this.hash, 16).toByteArray(), "md5"));
        }
        return Collections.emptyList();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    public static final class SIRange
    implements Range {
        @XmlAttribute
        private long offset;
        @XmlAttribute
        private long length;

        private SIRange() {
        }

        public SIRange(long offset, long length) {
            this.offset = offset;
            this.length = length;
        }

        @Override
        public long getOffset() {
            return this.offset;
        }

        @Override
        public long getLength() {
            return this.length;
        }
    }
}

