/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.time.model;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.extensions.time.model.TimeZoneAdapter;

@XmlRootElement(name="time")
public final class EntityTime {
    public static final String NAMESPACE = "urn:xmpp:time";
    @XmlJavaTypeAdapter(value=TimeZoneAdapter.class)
    @XmlElement(name="tzo")
    private TimeZone tzo;
    @XmlJavaTypeAdapter(value=UTCDateAdapter.class)
    @XmlElement(name="utc")
    private Date utc;

    public EntityTime() {
    }

    public EntityTime(TimeZone timeZone, Date date) {
        this.tzo = timeZone;
        this.utc = date;
    }

    public static Date toUtcDate(String v) {
        Calendar calendar = DatatypeConverter.parseDateTime((String)v);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        return calendar.getTime();
    }

    public static String toUtcString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        return DatatypeConverter.printDateTime((Calendar)calendar);
    }

    public TimeZone getTimezone() {
        return this.tzo;
    }

    public Date getDate() {
        return this.utc;
    }

    public String toString() {
        if (this.utc != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.utc);
            if (this.tzo != null) {
                calendar.setTimeZone(this.tzo);
            }
            return calendar.getTime().toString();
        }
        return super.toString();
    }

    private static class UTCDateAdapter
    extends XmlAdapter<String, Date> {
        private UTCDateAdapter() {
        }

        public Date unmarshal(String v) throws Exception {
            return EntityTime.toUtcDate(v);
        }

        public String marshal(Date v) throws Exception {
            return EntityTime.toUtcString(v);
        }
    }
}

