/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.amp.model;

import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlAttribute;

public final class Rule {
    @XmlAttribute(name="action")
    private final Action action;
    @XmlAttribute(name="condition")
    private final Condition condition;
    @XmlAttribute(name="value")
    private final String value;

    private Rule() {
        this.action = null;
        this.condition = null;
        this.value = null;
    }

    public Rule(Action action, Condition condition, String value) {
        this.action = Objects.requireNonNull(action);
        this.condition = Objects.requireNonNull(condition);
        this.value = Objects.requireNonNull(value);
    }

    public static Rule expireAt(Action action, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new Rule(action, Condition.EXPIRE_AT, DatatypeConverter.printDateTime((Calendar)calendar));
    }

    public static Rule deliver(Action action, DeliverValue value) {
        return new Rule(action, Condition.DELIVER, value.name().toLowerCase());
    }

    public static Rule matchResource(Action action, MatchResourceValue value) {
        return new Rule(action, Condition.MATCH_RESOURCE, value.name().toLowerCase());
    }

    public final Action getAction() {
        return this.action;
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public final String getValue() {
        return this.value;
    }

    public static enum MatchResourceValue {
        ANY,
        EXACT,
        OTHER;

    }

    public static enum DeliverValue {
        DIRECT,
        FORWARD,
        GATEWAY,
        NONE,
        STORED;

    }

    public static enum Condition {
        DELIVER,
        EXPIRE_AT,
        MATCH_RESOURCE;

    }

    public static enum Action {
        ALERT,
        DROP,
        ERROR,
        NOTIFY;

    }
}

