/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bookmarks.model;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.bookmarks.model.Bookmark;

public final class ChatRoomBookmark
extends Bookmark {
    @XmlElement(name="nick")
    private final String nick;
    @XmlElement(name="password")
    private final String password;
    @XmlAttribute(name="autojoin")
    private final Boolean autojoin;
    @XmlAttribute(name="jid")
    private final Jid room;

    private ChatRoomBookmark() {
        super(null);
        this.room = null;
        this.nick = null;
        this.password = null;
        this.autojoin = null;
    }

    public ChatRoomBookmark(String name, Jid room) {
        super(name);
        this.room = Objects.requireNonNull(room);
        this.nick = null;
        this.password = null;
        this.autojoin = null;
    }

    public ChatRoomBookmark(String name, Jid room, String nick, String password, boolean autojoin) {
        super(name);
        this.room = room;
        this.nick = nick;
        this.password = password;
        this.autojoin = autojoin;
    }

    public final String getNick() {
        return this.nick;
    }

    public final String getPassword() {
        return this.password;
    }

    public final boolean isAutojoin() {
        return this.autojoin != null && this.autojoin != false;
    }

    public final Jid getRoom() {
        return this.room;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatRoomBookmark)) {
            return false;
        }
        ChatRoomBookmark other = (ChatRoomBookmark)o;
        return Objects.equals(this.room, other.room);
    }

    public final int hashCode() {
        return Objects.hash(this.room);
    }

    public final String toString() {
        return this.getName() + ": " + (this.room != null ? this.room.toString() : "");
    }
}

